/**
 * Created by ChenXin on 2018/8/13.
 */

layui.define(['jquery', 'Hussar', 'HussarAjax'], function (exports) {
    var $ = layui.jquery
        , Hussar = layui.Hussar
        , $ax = layui.HussarAjax;
    var HussarBpm = {

        //加载流程图信息，processId——流程id，title——标题，callback——success后的回调
        processPic: function (processId, title, callback) {
            layer.open({
                type: 2,
                title: title,
                maxmin: true,
                content: hussar_path + "/ProcessPicController/processPic?processId=" + processId,
                area: ["100%", "100%"],
                success: function () {
                    callback.call(this);
                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //加载流程图实例信息(包含节点信息)，processId——流程实例id，title——标题，callback——success后的回调
        processPicInfo: function (processId, title, callback) {
            layer.open({
                type: 2,
                title: title,
                maxmin: true,
                content: hussar_path + "/ProcessPicController/processPicInfo?processId=" + processId,
                area: ["100%", "100%"],
                success: function () {
                    callback.call(this);
                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //加载流程图实例信息(包含节点信息)，processId——流程实例id，title——标题，callback——success后的回调
        processpicTab: function (processId, title, callback) {
            layer.open({
                type: 2,
                title: title,
                maxmin: true,
                content: hussar_path + "/ProcessPicController/processpicTab?processId=" + processId,
                area: ["100%", "100%"],
                success: function () {
                    callback.call(this);

                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //根据业务id加载流程图实例信息(包含节点信息)，processId——流程实例id，title——标题，callback——success后的回调
        processpicTabByBiz: function (bizId, title, callback) {
            layer.open({
                type: 2,
                title: title,
                maxmin: true,
                content: hussar_path + "/ProcessPicController/processpicTabByBiz?bizId=" + bizId,
                area: ["100%", "100%"],
                success: function () {
                    callback.call(this);

                },
                end: function () {
                    $('#picWindow').hide();
                }
            });
        },
        //根据流程实例ID获取流程定义信息，processInstanceId——流程实例id
        processDefinition: function (processInstanceId, callback) {
            var ajax = new $ax(hussar_path + "/instance/queryProcessDefinitionByInstanceId",
                function (result) {
                    callback.call(this, result);
                }, function (result) {
                    callback.call(this, result);
                });
            ajax.set("processInstanceId", processInstanceId);
            ajax.start();
        },
        //查询当前流程是否完成，processInstanceId——流程实例id，callback——ajax回调函数
        ProcessInstanceCompleteState: function (processInstanceId, callback) {
            var ajax = new $ax(hussar_path + "/instance/queryProcessInstanceCompleteState",
                function (result) {
                    callback.call(this, result); //成功回调
                }, function (result) {
                    callback.call(this, result); //失败回调
                });
            ajax.set("processInstanceId", processInstanceId);
            ajax.start();
        },

        //签收任务（任务ID，用户ID）
        claimTask: function (taskId, userId, callback) {
            var ajax = new $ax(hussar_path + "/task/claimTask",
                function (result) {
                    callback.call(this, result); //成功回调
                }, function (result) {
                    callback.call(this, result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.start();
        },
        //取消签收
        unClaimTask: function (taskId, callback) {
            var ajax = new $ax(hussar_path + "/task/unClaimTask",
                function (result) {
                    callback.call(this, result); //成功回调
                }, function (result) {
                    callback.call(this, result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.start();
        },

        //委托
        delegateTask: function (taskId, userId, callback) {
            var ajax = new $ax(hussar_path + "/task/delegateTask",
                function (result) {
                    callback.call(this, result); //成功回调
                }, function (result) {
                    callback.call(this, result); //失败回调
                });
            ajax.set("taskId", taskId);
            ajax.set("userId", userId);
            ajax.start();
        },
        //能否撤回(historicTaskId 历史任务ID)
        withdrawState: function (historicTaskId, callback) {
            var ajax = new $ax(hussar_path + "/task/withdrawState",
                function (result) {
                    callback.call(this, result); //成功回调
                }, function (result) {
                    callback.call(this, result); //失败回调
                });
            ajax.set("historicTaskId", historicTaskId);
            ajax.start();
        },
        //撤回（业务id，人员id）
        revokeTask: function (historicTaskId, businessId, userId, callback) {
            this.withdrawState(historicTaskId, function (data) {
                if (data.result == "false") {
                    Hussar.info("下一节点已办理，不能撤回！");
                    return;
                } else {
                    var ajax = new $ax(hussar_path + "/revokeTask",
                        function (result) {
                            callback.call(this, result); //成功回调
                        }, function (result) {
                            callback.call(this, result); //失败回调
                        });
                    ajax.set("businessId", businessId);
                    ajax.set("userId", userId);
                    ajax.start();
                }
            })
        }
    };
    exports('HussarBpm', HussarBpm);
});
