/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.basic.components.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigBoService;
import com.jxdinfo.hussar.basic.components.properties.HussarCodeProperties;
import com.jxdinfo.hussar.basic.components.service.IHussarAppFrameService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.basic.components.service.impl.HussarAppFrameServiceImpl")
public class HussarAppFrameServiceImpl
implements IHussarAppFrameService {
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private HussarCodeProperties hussarCodeProperties;
    @Resource
    private IPageViewConfigBoService pageViewConfigBoService;

    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        return this.userBoService.getUsersByOrganUser(organIds, userIds);
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        return this.userBoService.lazyOrganUserTree(parentOrganIds, needParentOrganInfo, resultType);
    }

    public List<ReadOnlyRoleTreeVo> getAppRoleTree(Long appId) {
        return this.sysRolesExternalService.getAppRoleTree(appId);
    }

    public ApiResponse<JSONObject> logo() {
        JSONObject logoObject = new JSONObject();
        String logo = this.hussarCodeProperties.getLogo();
        if (HussarUtils.isNotEmpty((Object)logo)) {
            logoObject = JSON.parseObject((String)logo);
        } else {
            String logoString = "{ \"nologo\": false, \"homePageInfo\": {}, \"portalUrl\": \"\", \"tokenName\": \"\"}";
            logoObject = JSON.parseObject((String)logoString);
        }
        Map homePageInfoObjectNew = this.pageViewConfigBoService.getHomePageInfo();
        logoObject.put("homePageInfo", (Object)homePageInfoObjectNew);
        return ApiResponse.success((Object)logoObject, (String)"\u64cd\u4f5c\u6210\u529f");
    }
}

