/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.rest.auth.filter;

import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.util.RenderUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.rest.auth.util.JwtTokenUtil;
import com.jxdinfo.hussar.rest.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.rest.config.properties.JwtProperties;
import com.jxdinfo.hussar.rest.config.properties.RestProperties;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private JwtProperties jwtProperties;
    @Autowired
    private RestProperties restProperties;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        block5: {
            String urlPattern = this.restProperties.getUrlPattern();
            urlPattern = urlPattern.substring(0, urlPattern.lastIndexOf("/"));
            if (!request.getServletPath().startsWith(urlPattern)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String requestHeader = request.getHeader(this.jwtProperties.getHeader());
            String authToken = null;
            if (ToolUtil.isNotEmpty((Object)requestHeader) && requestHeader.startsWith(this.restProperties.getTokenHeaderCode())) {
                authToken = requestHeader.substring(this.restProperties.getTokenHeaderCode().length());
                try {
                    boolean flag = this.jwtTokenUtil.isTokenExpired(authToken);
                    if (flag) {
                        RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_EXPIRED.getCode().intValue(), BizExceptionEnum.TOKEN_EXPIRED.getMessage()));
                        return;
                    }
                    break block5;
                }
                catch (JwtException e) {
                    RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_ERROR.getCode().intValue(), BizExceptionEnum.TOKEN_ERROR.getMessage()));
                    return;
                }
            }
            RenderUtil.renderJson((HttpServletResponse)response, (Object)new ErrorTip(BizExceptionEnum.TOKEN_ERROR.getCode().intValue(), BizExceptionEnum.TOKEN_ERROR.getMessage()));
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

