/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import io.buji.pac4j.subject.Pac4jPrincipal;
import io.buji.pac4j.token.Pac4jToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.shiro.subject.PrincipalCollection;
import org.pac4j.core.profile.CommonProfile;

public class IscUtil {
    public static ShiroUser getShiroUserFromPac4jToken(Pac4jToken token) {
        ShiroUser user = new ShiroUser();
        List commonProfileList = token.getProfiles();
        if (commonProfileList.size() > 0) {
            CommonProfile commonProfile = (CommonProfile)commonProfileList.get(0);
            String id = commonProfile.getId();
            try {
                JSONObject json = JSONObject.parseObject((String)URLDecoder.decode(id, "UTF-8"));
                String iscUserId = json.get((Object)"iscUserId").toString();
                String iscUserSourceId = json.get((Object)"iscUserSourceId").toString();
                String iscAdCode = json.get((Object)"iscAdCode").toString();
                String baseOrgId = json.get((Object)"baseOrgId").toString();
                user.setId(iscUserId);
                user.setDeptId(baseOrgId);
                user.setName(iscAdCode);
                user.setAccount(iscUserSourceId);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return user;
    }

    public static ShiroUser getShiroUserFromPrincipalCollection(PrincipalCollection principals) {
        Pac4jPrincipal principal = (Pac4jPrincipal)principals.getPrimaryPrincipal();
        return IscUtil.getShiroUserFromPac4jPrincipal(principal);
    }

    public static ShiroUser getShiroUserFromPac4jPrincipal(Pac4jPrincipal principal) {
        ShiroUser user = new ShiroUser();
        CommonProfile profile = principal.getProfile();
        String id = profile.getId();
        try {
            JSONObject json = JSONObject.parseObject((String)URLDecoder.decode(id, "UTF-8"));
            String iscUserId = json.get((Object)"iscUserId").toString();
            String iscUserSourceId = json.get((Object)"iscUserSourceId").toString();
            String iscAdCode = json.get((Object)"iscAdCode").toString();
            String baseOrgId = json.get((Object)"baseOrgId").toString();
            user.setId(iscUserId);
            user.setDeptId(baseOrgId);
            user.setName(iscAdCode);
            user.setAccount(iscUserSourceId);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return user;
    }
}

