/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.core.util.EncryptUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AESEncrypUtil {
    public static final String KEY_ALGORITHM = "AES";
    private static final String KEY = "";
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static String aesDecrypt(String encrypt) {
        try {
            return AESEncrypUtil.decrypt(KEY, encrypt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return KEY;
        }
    }

    public static String aesEncrypt(String content) {
        try {
            return AESEncrypUtil.encrypt(KEY, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return KEY;
        }
    }

    private static byte[] aesEncryptToBytes(String encryptKey, String content) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
            kgen.init(128);
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(1, new SecretKeySpec(encryptKey.getBytes("UTF-8"), KEY_ALGORITHM));
            return cipher.doFinal(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String encryptKey, String content) {
        try {
            return new String(EncryptUtil.Base64Encode((byte[])AESEncrypUtil.aesEncryptToBytes(encryptKey, content)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(EncryptUtil.Base64Encode((byte[])AESEncrypUtil.aesEncryptToBytes(encryptKey, content)));
        }
    }

    public static String aesDecryptByBytes(String decryptKey, byte[] encryptBytes) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
            kgen.init(128);
            Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
            cipher.init(2, new SecretKeySpec(decryptKey.getBytes("UTF-8"), KEY_ALGORITHM));
            byte[] decryptBytes = cipher.doFinal(encryptBytes);
            return new String(decryptBytes, "UTF-8");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decrypt(String decryptKey, String encryptStr) {
        try {
            return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AESEncrypUtil.aesDecryptByBytes(decryptKey, EncryptUtil.Base64Decode((byte[])encryptStr.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return KEY;
        }
    }
}

