/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.lock;

import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.shiro.lock.UserLockModel;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Date;

public class MapLoginLock
implements LoginLock {
    private static final String LOINLOCK = "Login_Lock";
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
    private GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
    int tryLoginTime = this.globalProperties.getTryLoginTime();
    int lockTime = this.globalProperties.getLockTime();

    @Override
    public boolean userIsLock(String userId) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model) && ToolUtil.isNotEmpty((Object)model.getExpireTime()) && DateUtil.compareDate((Date)new Date(), (Date)model.getExpireTime()) == -1) {
            flag = true;
        }
        return flag;
    }

    @Override
    public int userLockNum(String userId) {
        int num = 0;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    @Override
    public boolean exisUser(String userId) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void addUserCache(String userId) {
        UserLockModel model = (UserLockModel)hussarCacheManager.getObject(LOINLOCK, userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            if (ToolUtil.isNotEmpty((Object)model.getExpireTime())) {
                model.setFailNum(0);
                model.setLockTime(null);
                model.setExpireTime(null);
            }
            model.setFailNum(model.getFailNum() + 1);
            if (model.getFailNum() >= this.tryLoginTime) {
                model.setLockTime(new Date());
                model.setExpireTime(DateUtil.addHour((Date)new Date(), (int)this.lockTime));
            }
        } else {
            UserLockModel newModel = new UserLockModel();
            newModel.setUserid(userId);
            newModel.setFailNum(1);
            if (newModel.getFailNum() >= this.tryLoginTime) {
                newModel.setLockTime(new Date());
                newModel.setExpireTime(DateUtil.addHour((Date)new Date(), (int)this.lockTime));
            }
            hussarCacheManager.setObject(LOINLOCK, userId, newModel);
        }
    }

    @Override
    public void removeUserCache(String userId) {
        hussarCacheManager.delete(LOINLOCK, userId);
    }
}

