/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.factory;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.persistence.dao.ResourcesMapper;
import com.jxdinfo.hussar.common.persistence.model.SysUsers;
import com.jxdinfo.hussar.common.persistence.service.IUsersService;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"springContextHolder"})
@Transactional(readOnly=true)
public class ShiroFactroy
implements IShiro {
    @Resource
    private IUsersService sysUsersService;
    @Resource
    private ResourcesMapper resourcesMapper;
    @Resource
    private HussarProperties hussarProperties;

    public static IShiro me() {
        return (IShiro)SpringContextHolder.getBean(IShiro.class);
    }

    @Override
    public SysUsers user(String account) {
        SysUsers user;
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            account = account.toUpperCase();
        }
        if (null == (user = (SysUsers)((Object)this.sysUsersService.selectOne(new EntityWrapper().eq("USER_ACCOUNT", (Object)account).ne("ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()))))) {
            throw new CredentialsException();
        }
        if (!UserStatus.OK.getCode().equals(user.getAccountStatus())) {
            throw new LockedAccountException();
        }
        return user;
    }

    @Override
    public ShiroUser shiroUser(SysUsers user) {
        ShiroUser shiroUser = new ShiroUser();
        shiroUser.setId(user.getUserId());
        shiroUser.setAccount(user.getUserAccount());
        shiroUser.setDeptId(user.getDepartmentId());
        shiroUser.setDeptName(ConstantFactory.me().getDeptName(user.getDepartmentId()));
        shiroUser.setName(user.getUserName());
        shiroUser.setSecurityLevel(user.getSecurityLevel());
        shiroUser.setAccountStatus(user.getAccountStatus());
        List<String> rolesList = ConstantFactory.me().getRolesIdByUserId(user.getUserId());
        shiroUser.setRolesList(rolesList);
        List<String> IsRepeatAuthenticate2 = ConstantFactory.me().getIsRepeatAuthenticateId(user.getUserId());
        shiroUser.setIsRepeatAuthenticate(IsRepeatAuthenticate2);
        return shiroUser;
    }

    @Override
    public List<String> getAuthInfo(ShiroUser shiroUser) {
        return ConstantFactory.me().getAuthInfo(shiroUser).get("userPermission");
    }

    @Override
    public List<String> findPermissionsByRoleId(String roleId) {
        List<String> resUrls = this.resourcesMapper.getResUrlsByRoleId(roleId);
        return resUrls;
    }

    @Override
    public String findRoleNameByRoleId(Integer roleId) {
        return ConstantFactory.me().getSingleRoleTip(roleId);
    }

    @Override
    public SimpleAuthenticationInfo info(ShiroUser shiroUser, SysUsers user, String realmName) {
        String credentials = user.getPassword();
        return new SimpleAuthenticationInfo((Object)shiroUser, (Object)credentials, realmName);
    }
}

