/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.encrypt;

import com.jxdinfo.hussar.config.properties.EncryptTypeProperties;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCredentialsMatcher
extends SimpleCredentialsMatcher {
    @Autowired
    private EncryptTypeProperties etp;
    @Autowired
    private GlobalProperties globalProperties;

    public boolean doCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) {
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String localhost = this.etp.getSecretFreeIp();
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        String username = token.getUsername();
        String password = String.valueOf(token.getPassword());
        String host = token.getHost();
        if (loginLock.userIsLock(username)) {
            throw new DisabledAccountException("\u7531\u4e8e\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7ecf\u7981\u6b62\u767b\u5f55\uff01");
        }
        boolean flag = false;
        if (StringUtils.isNotEmpty((CharSequence)host) && StringUtils.isNotEmpty((CharSequence)localhost) && this.equals(host, localhost)) {
            flag = this.equals(this.passwordEncode(username.getBytes()), password);
        } else {
            String tokenCredentials = this.passwordEncode(password.getBytes());
            Object accountCredentials = this.getCredentials(info);
            flag = this.equals(tokenCredentials.toUpperCase(), ((String)accountCredentials).toUpperCase());
        }
        if (!flag) {
            loginLock.addUserCache(username);
            int loginChance = this.globalProperties.getTryLoginTime() - loginLock.userLockNum(username);
            throw new CredentialsException("\u8fd8\u6709" + loginChance + "\u6b21\u673a\u4f1a");
        }
        loginLock.removeUserCache(username);
        return flag;
    }

    public abstract String passwordEncode(byte[] var1);
}

