/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.check;

import com.jxdinfo.hussar.core.listener.ConfigListener;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.check.ICheck;
import com.jxdinfo.hussar.core.support.CollectionKit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"springContextHolder"})
@Transactional(readOnly=true)
public class PermissionCheckFactory
implements ICheck {
    public static ICheck me() {
        return (ICheck)SpringContextHolder.getBean(ICheck.class);
    }

    @Override
    public boolean check(Object[] permissions) {
        ShiroUser user = ShiroKit.getUser();
        if (null == user) {
            return false;
        }
        String join = CollectionKit.join((Object[])permissions, (String)",");
        return ShiroKit.hasAnyRoles(join);
    }

    @Override
    public boolean checkAll() {
        HttpServletRequest request = HttpKit.getRequest();
        ShiroUser user = ShiroKit.getUser();
        if (null == user) {
            return false;
        }
        String requestURI = request.getRequestURI().replaceFirst((String)ConfigListener.getConf().get("contextPath"), "");
        String[] str = requestURI.split("/");
        if (str.length > 3) {
            requestURI = "/" + str[1] + "/" + str[2];
        }
        return ShiroKit.hasPermission(requestURI);
    }
}

