/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro;

import com.jxdinfo.hussar.common.persistence.service.IOnlineHistService;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.springframework.stereotype.Component;

@Component
public class HussarSessionListener
implements SessionListener {
    public void onStart(Session session) {
    }

    public void onStop(Session session) {
        String userId;
        SessionLimit sessionLimit;
        Deque<Serializable> deque;
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarLogManager.me().executeLog(LogTaskFactory.exitLog(shiroUser, "06", info));
        }
        IOnlineHistService iOnlineHistService = (IOnlineHistService)SpringContextHolder.getBean(IOnlineHistService.class);
        iOnlineHistService.updateLogoffTime();
        GlobalProperties gp = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (gp.isSessionLimit() && gp.isKickoutAfter() && ToolUtil.isNotEmpty(deque = (sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class)).getUserSession(userId = (String)session.getAttribute((Object)"userId")))) {
            deque.remove(session.getId());
            sessionLimit.addUserSession(userId, deque);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
            hussarCacheManager.delete("authorization_info", "shiro_authInfo:" + shiroUser.getId());
            hussarCacheManager.delete("menu_info", "shiro_menus:" + shiroUser.getId());
        }
        SessionDAO sessionDAO = (SessionDAO)SpringContextHolder.getBean(SessionDAO.class);
        sessionDAO.delete(session);
    }

    public void onExpiration(Session session) {
        String userId;
        SessionLimit sessionLimit;
        Deque<Serializable> deque;
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)session.getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarLogManager.me().executeLog(LogTaskFactory.exitLog(shiroUser, "06", info));
        }
        IOnlineHistService iOnlineHistService = (IOnlineHistService)SpringContextHolder.getBean(IOnlineHistService.class);
        iOnlineHistService.updateLogoffTime();
        GlobalProperties gp = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (gp.isSessionLimit() && gp.isKickoutAfter() && ToolUtil.isNotEmpty(deque = (sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class)).getUserSession(userId = (String)session.getAttribute((Object)"userId")))) {
            deque.remove(session.getId());
            sessionLimit.addUserSession(userId, deque);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
            hussarCacheManager.delete("authorization_info", "shiro_authInfo:" + shiroUser.getId());
            hussarCacheManager.delete("menu_info", "shiro_menus:" + shiroUser.getId());
        }
        SessionDAO sessionDAO = (SessionDAO)SpringContextHolder.getBean(SessionDAO.class);
        sessionDAO.delete(session);
    }
}

