/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Tuple;
import redis.clients.util.Slowlog;

@Component
public class RedisUtil {
    private static Logger logger = LogManager.getLogger(RedisUtil.class);
    @Autowired
    JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedisInfo() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Client client = jedis.getClient();
            client.info();
            String string = client.getBulkReply();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> getLogs(long entries) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            List list = jedis.slowlogGet(entries);
            return list;
        }
    }

    public Long getLogsLen() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Long l = jedis.slowlogLen();
            return l;
        }
    }

    public String logEmpty() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String string = jedis.slowlogReset();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long dbSize() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            Client client = jedis.getClient();
            client.dbSize();
            Long l = client.getIntegerReply();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDbAmountForRedis() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            List e = jedis.configGet("databases");
            int dbAmount1 = e.size() > 0 ? Integer.parseInt((String)e.get(1)) : 15;
            int n = dbAmount1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getNoSQLDBForRedis(int pageSize, int limitFrom, String noSQLDbName, String selectKey) {
        String currentDBindex = noSQLDbName.substring(2, noSQLDbName.length());
        HashMap<String, Object> tempMap = new HashMap<String, Object>(4);
        Jedis jedis = null;
        ArrayList list = new ArrayList();
        try {
            int i;
            jedis = this.jedisPool.getResource();
            jedis.select(Integer.parseInt(currentDBindex));
            Long dbSize = jedis.dbSize();
            Set nodekeys = new HashSet();
            String nokeyString = "nokey";
            long dbSizeLimit = 1000L;
            if (nokeyString.equals(selectKey)) {
                if (dbSize > dbSizeLimit) {
                    limitFrom = 0;
                    for (int it = 0; it < pageSize; ++it) {
                        ((Set)nodekeys).add(jedis.randomKey());
                    }
                } else {
                    nodekeys = jedis.keys("*");
                }
            } else {
                nodekeys = jedis.keys("*" + selectKey + "*");
            }
            Iterator it = ((Set)nodekeys).iterator();
            String value = "";
            for (i = 1; it.hasNext() && i < limitFrom + pageSize; ++i) {
                if (i >= limitFrom) {
                    Long lon;
                    HashMap<String, Object> map = new HashMap<String, Object>(4);
                    String key = (String)it.next();
                    String type = jedis.type(key);
                    map.put("key", key);
                    map.put("type", type);
                    if ("string".equals(type)) {
                        value = jedis.get(key);
                        if (value.length() > 1000) {
                            map.put("value", value.substring(0, 999) + "......");
                        } else {
                            map.put("value", value);
                        }
                    }
                    if ("list".equals(type)) {
                        lon = jedis.llen(key);
                        if (lon > 20L) {
                            lon = 20L;
                        }
                        map.put("value", jedis.lrange(key, 0L, lon.longValue()));
                    }
                    if ("set".equals(type)) {
                        map.put("value", jedis.smembers(key).toString());
                    }
                    if ("zset".equals(type)) {
                        lon = jedis.zcard(key);
                        if (lon > 20L) {
                            lon = 20L;
                        }
                        Set set = jedis.zrangeWithScores(key, 0L, lon.longValue());
                        Iterator itt = set.iterator();
                        String ss = "";
                        while (itt.hasNext()) {
                            Tuple str = (Tuple)itt.next();
                            StringBuilder ssBuilder = new StringBuilder(100);
                            ss = ssBuilder.append(ss).append("[").append(str.getScore()).append(",").append(str.getElement()).append("],").toString();
                        }
                        ss = ss.substring(0, ss.length() - 1);
                        map.put("value", "[" + ss + "]");
                    }
                    if ("hash".equals(type)) {
                        map.put("value", jedis.hgetAll(key).toString());
                    }
                    list.add(map);
                    continue;
                }
                it.next();
            }
            if (nokeyString.equals(selectKey)) {
                tempMap.put("rowCount", Integer.parseInt(dbSize.toString()));
            } else {
                tempMap.put("rowCount", i - 1);
            }
            tempMap.put("dataList", list);
        }
        catch (Exception e) {
            String info = "\u53d6\u5f97 NoSQL\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage();
            logger.error(info);
            System.out.println(info);
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.disconnect();
                jedis.close();
            }
        }
        return tempMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKeys(String noSQLDbName, String[] ids) {
        Jedis jedis = null;
        String currentDBindex = noSQLDbName.substring(2, noSQLDbName.length());
        try {
            jedis = this.jedisPool.getResource();
            jedis.select(Integer.parseInt(currentDBindex));
            for (String id : ids) {
                jedis.del(new String[]{id});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (jedis != null) {
                jedis.disconnect();
                jedis.close();
            }
        }
    }

    public String getDateStr(long timeStmp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(timeStmp));
    }
}

