/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.core.redis.model.Operate;
import com.jxdinfo.hussar.core.redis.model.RedisInfoDetail;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.redis.util.RedisUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import redis.clients.util.Slowlog;

@Service
public class RedisServiceImpl
implements RedisService {
    private static Logger logger = LogManager.getLogger(RedisServiceImpl.class);
    @Value(value="${spring.redis.host}")
    private String host;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public void setObject(String key, Object obj) {
        ValueOperations vo = this.redisTemplate.opsForValue();
        vo.set((Object)key, obj);
    }

    @Override
    public Object getObject(String key) {
        ValueOperations vo = this.redisTemplate.opsForValue();
        return vo.get((Object)key);
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public List<RedisInfoDetail> getRedisInfo() {
        String info = this.redisUtil.getRedisInfo();
        ArrayList<RedisInfoDetail> ridList = new ArrayList<RedisInfoDetail>();
        String[] strs = info.split("\n");
        RedisInfoDetail rif = null;
        if (strs != null && strs.length > 0) {
            for (String str1 : strs) {
                rif = new RedisInfoDetail();
                String[] str = str1.split(":");
                if (str == null || str.length <= 1) continue;
                String key = str[0];
                String value = str[1];
                rif.setKey(key);
                rif.setValue(value);
                ridList.add(rif);
            }
        }
        return ridList;
    }

    @Override
    public List<Operate> getLogs(long entries) {
        List<Slowlog> list = this.redisUtil.getLogs(entries);
        LinkedList<Operate> opList = new LinkedList<Operate>();
        Operate op = null;
        if (list != null && list.size() > 0) {
            for (Slowlog sl : list) {
                String args = JSON.toJSONString((Object)sl.getArgs());
                if ("[\"PING\"]".equals(args) || "[\"SLOWLOG\",\"get\"]".equals(args) || "[\"DBSIZE\"]".equals(args) || "[\"INFO\"]".equals(args)) continue;
                op = new Operate();
                op.setId(sl.getId());
                op.setExecuteTime(this.getDateStr(sl.getTimeStamp() * 1000L));
                op.setUsedTime((double)sl.getExecutionTime() / 1000.0 + "ms");
                op.setArgs(args);
                opList.add(op);
            }
        }
        return opList;
    }

    @Override
    public Long getLogLen() {
        return this.redisUtil.getLogsLen();
    }

    @Override
    public String logEmpty() {
        return this.redisUtil.logEmpty();
    }

    @Override
    public Map<String, Object> getKeysSize() {
        long dbSize = this.redisUtil.dbSize();
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("create_time", System.currentTimeMillis());
        map.put("dbSize", dbSize);
        return map;
    }

    @Override
    public Map<String, Object> getMemeryInfo() {
        String[] strs = this.redisUtil.getRedisInfo().split("\n");
        HashMap<String, Object> map = null;
        for (String s : strs) {
            String[] detail = s.split(":");
            if (!"used_memory".equals(detail[0])) continue;
            map = new HashMap<String, Object>(2);
            map.put("used_memory", detail[1].substring(0, detail[1].length() - 1));
            map.put("create_time", System.currentTimeMillis());
            break;
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getAllDataBaseForRedis() {
        ArrayList<Map<String, Object>> listAll = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> tempObject = new HashMap<String, Object>(8);
        try {
            int e = 0;
            int index = e + 1;
            tempObject.put("id", index);
            tempObject.put("name", this.host);
            tempObject.put("type", "database");
            tempObject.put("icon", "icon-hamburg-database");
            listAll.add(tempObject);
            int pid = index;
            int dbAmount = this.redisUtil.getDbAmountForRedis();
            for (int y = 0; y < dbAmount; ++y) {
                HashMap<String, Object> tempObjectTable2 = new HashMap<String, Object>(8);
                tempObjectTable2.put("id", ++index);
                tempObjectTable2.put("pid", pid);
                tempObjectTable2.put("name", "DB" + y);
                tempObjectTable2.put("icon", "icon-berlin-project");
                tempObjectTable2.put("type", "table");
                listAll.add(tempObjectTable2);
            }
            return listAll;
        }
        catch (Exception e) {
            String info = "\u53d6\u5f97reids\u4e2d\u6570\u636e\u5e93\u6570\u636e\u51fa\u9519,\u53ef\u80fd\u6570\u636e\u5e93\u8fde\u63a5\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff01\n " + e.getMessage();
            logger.error(info);
            System.out.println(info);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Page<Map<String, Object>> getNoSQLDBForRedis(Page<Map<String, Object>> page, String noSQLDbName, String selectKey) {
        int pageNo = page.getCurrent();
        int pageSize = page.getSize();
        int limitFrom = (pageNo - 1) * pageSize + 1;
        Map<String, Object> tempMap = this.redisUtil.getNoSQLDBForRedis(pageSize, limitFrom, noSQLDbName, selectKey);
        page.setTotal(((Integer)tempMap.get("rowCount")).intValue());
        page.setRecords((List)tempMap.get("dataList"));
        return page;
    }

    @Override
    public boolean deleteNoSQLKeyForRedis(String noSQLDbName, String[] ids) {
        return this.redisUtil.deleteKeys(noSQLDbName, ids);
    }

    private String getDateStr(long timeStmp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(timeStmp));
    }

    @Override
    public void deleteMoreByKeys(String key) {
        Set keys = this.redisTemplate.keys((Object)("*" + key + "*"));
        this.redisTemplate.delete((Collection)keys);
    }

    @Override
    public List<Object> getKeys(String key) {
        Set keys = this.redisTemplate.keys((Object)("*" + key + "*"));
        return new ArrayList<Object>(keys);
    }

    @Override
    public List<Map<Object, Object>> getKeyAndValues(String key) {
        ArrayList<Map<Object, Object>> returnList = new ArrayList<Map<Object, Object>>();
        Set keys = this.redisTemplate.keys((Object)("*" + key + "*"));
        ValueOperations vo = this.redisTemplate.opsForValue();
        HashMap<String, Object> tmpMap = null;
        for (String tmpkey : keys) {
            tmpMap = new HashMap<String, Object>(2);
            tmpMap.put("value", vo.get((Object)tmpkey));
            tmpMap.put("key", tmpkey);
            returnList.add(tmpMap);
        }
        return returnList;
    }
}

