/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource.aop;

import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import com.jxdinfo.hussar.core.mutidatasource.annotion.DataSource;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="hussar", name={"muti-datasource-open"}, havingValue="true")
public class MultiSourceExAop
implements Ordered {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.jxdinfo.hussar.core.mutidatasource.annotion.DataSource)")
    private void cut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = null;
        if (!(signature instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        methodSignature = (MethodSignature)signature;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        DataSource datasource = currentMethod.getAnnotation(DataSource.class);
        if (datasource != null) {
            DataSourceContextHolder.setDataSourceType(datasource.name());
            this.log.debug("\u8bbe\u7f6e\u6570\u636e\u6e90\u4e3a\uff1a" + datasource.name());
        } else {
            DataSourceContextHolder.setDataSourceType("dataSourceHussar");
            this.log.debug("\u8bbe\u7f6e\u6570\u636e\u6e90\u4e3a\uff1adataSourceCurrent");
        }
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            this.log.debug("\u6e05\u7a7a\u6570\u636e\u6e90\u4fe1\u606f\uff01");
            DataSourceContextHolder.clearDataSourceType();
        }
    }

    public int getOrder() {
        return 1;
    }
}

