/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.logdownload.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.Log4jUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/logDownload"})
public class LogDownLoadController
extends BaseController {
    private static String PREFIX = "/core/log/";
    private static Map<String, String> FILE_PATH = new HashMap<String, String>();

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"logDownload:view"})
    public String view() {
        return PREFIX + "logDownload.html";
    }

    @RequestMapping(value={"/logTree"})
    @ResponseBody
    public Object getOrganTree() {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String path = Log4jUtil.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
        }
        String pathId = UUID.randomUUID().toString();
        if (!FILE_PATH.containsValue(path)) {
            FILE_PATH.put(pathId, path);
        }
        File file = new File(path);
        String rootName = file.getName();
        result = this.getLogDirectory(file, result);
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("id", rootName);
        root.put("text", "\u65e5\u5fd7\u76ee\u5f55");
        root.put("parent", "#");
        root.put("type", "root");
        root.put("path", LogDownLoadController.getKey(FILE_PATH, path));
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/logTable"})
    @ResponseBody
    public Object getLogTable() {
        String pathId = super.getPara("pathId");
        String directory = FILE_PATH.get(pathId);
        Page page = new Page();
        List<Map<String, Object>> list = this.getFiles(directory);
        page.setRecords(list);
        page.setTotal(list.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", page.getRecords());
        map.put("code", "0");
        map.put("msg", "");
        map.put("count", page.getTotal());
        return map;
    }

    @RequestMapping(value={"/download"})
    public void fileDownload(HttpServletResponse response) {
        String fileId = super.getPara("fileId");
        String filePath = FILE_PATH.get(fileId);
        File file = new File(filePath);
        String fileName = file.getName();
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            int b = 0;
            byte[] buffer = new byte[512];
            while (b != -1) {
                b = inputStream.read(buffer);
                out.write(buffer, 0, b);
            }
            inputStream.close();
            out.close();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Map<String, Object>> getLogDirectory(File file, List<Map<String, Object>> resultFiles) {
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return resultFiles;
        }
        for (File f : files) {
            String filePath = f.getAbsolutePath();
            String pathId = UUID.randomUUID().toString();
            if (!FILE_PATH.containsValue(filePath)) {
                FILE_PATH.put(pathId, filePath);
            }
            if (!f.isDirectory()) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put("id", f.getName());
            node.put("text", f.getName());
            node.put("parent", f.getParentFile().getName());
            node.put("type", "directory");
            node.put("path", LogDownLoadController.getKey(FILE_PATH, filePath));
            resultFiles.add(node);
            this.getLogDirectory(f, resultFiles);
        }
        return resultFiles;
    }

    private List<Map<String, Object>> getFiles(String directory) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        File file = new File(directory);
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return result;
        }
        for (File f : files) {
            if (!f.isFile() || !file.getPath().equals(f.getParent())) continue;
            if (!FILE_PATH.containsValue(f.getAbsolutePath())) {
                String uuid = UUID.randomUUID().toString();
                FILE_PATH.put(uuid, f.getAbsolutePath());
            }
            HashMap<String, Object> node = new HashMap<String, Object>(3);
            String filePath = f.getAbsolutePath();
            node.put("fileId", LogDownLoadController.getKey(FILE_PATH, filePath));
            node.put("fileName", f.getName());
            node.put("fileSize", f.length() / 1024L);
            node.put("fileLastEditTime", this.formatDate(f.lastModified()));
            result.add(node);
        }
        return result;
    }

    private String formatDate(long timestamp) {
        Date date = new Date();
        date.setTime(timestamp);
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getKey(Map<String, String> map, String value) {
        String key = null;
        for (String getKey : map.keySet()) {
            if (!map.get(getKey).equals(value)) continue;
            key = getKey;
        }
        return key;
    }
}

