/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.factory;

import com.jxdinfo.hussar.common.constant.state.LogSucceed;
import com.jxdinfo.hussar.common.constant.state.LogType;
import com.jxdinfo.hussar.common.persistence.dao.ResourcesMapper;
import com.jxdinfo.hussar.common.persistence.dao.SecurityLogMapper;
import com.jxdinfo.hussar.common.persistence.model.SysSecurityLog;
import com.jxdinfo.hussar.core.db.Db;
import com.jxdinfo.hussar.core.log.factory.LogFactory;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTaskFactory {
    private static Logger logger = LoggerFactory.getLogger(LogTaskFactory.class);
    private static SecurityLogMapper securityLogMapper = Db.getMapper(SecurityLogMapper.class);
    private static ResourcesMapper resourcesMapper = Db.getMapper(ResourcesMapper.class);

    public static TimerTask loginLog(final ShiroUser user, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    SysSecurityLog sysSecurityLog = LogFactory.createLoginLog(LogType.LOGIN, user, "\u767b\u5f55", info, type);
                    securityLogMapper.insert((Object)sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u767b\u5f55\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask loginLog(final String username, final String msg, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                SysSecurityLog sysSecurityLog = LogFactory.createLoginExceptionLog(LogType.LOGIN_FAIL, username, "\u8d26\u53f7:" + username + "," + msg, info, type);
                try {
                    securityLogMapper.insert((Object)sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u767b\u5f55\u5931\u8d25\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exitLog(final ShiroUser user, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                SysSecurityLog sysSecurityLog = LogFactory.createLoginLog(LogType.EXIT, user, "\u767b\u51fa", info, type);
                try {
                    securityLogMapper.insert((Object)sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u9000\u51fa\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask bussinessLog(final ShiroUser user, final String bussinessName, final String className, final String methodName, final String msg, final Map<String, String> info, final String key, final String type) {
        return new TimerTask(){

            @Override
            public void run() {
                SysSecurityLog sysSecurityLog = LogFactory.createSysSecurityLog(LogType.BUSSINESS, user, bussinessName, className, methodName, msg, LogSucceed.SUCCESS, info, type);
                try {
                    Map<String, String> result = resourcesMapper.getResourceInfoByUrl(key);
                    if (ToolUtil.isNotEmpty(result)) {
                        sysSecurityLog.setResourceId(result.get("RESOURCEID"));
                        sysSecurityLog.setResourceAlias(result.get("RESOURCEALIAS"));
                        if ("1".equals(result.get("ISAUDIT"))) {
                            securityLogMapper.insert((Object)sysSecurityLog);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u4e1a\u52a1\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exceptionLog(final ShiroUser user, final Exception exception) {
        return new TimerTask(){

            @Override
            public void run() {
                String msg = ToolUtil.getExceptionMsg((Exception)exception);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("ip", HttpKit.getIp());
                info.put("port", HttpKit.getPort());
                info.put("host", HttpKit.getHost());
                info.put("localIp", HttpKit.getLocalIp());
                info.put("localPort", HttpKit.getLocalPort());
                info.put("localHost", HttpKit.getLocalHost());
                SysSecurityLog sysSecurityLog = LogFactory.createSysSecurityLog(LogType.EXCEPTION, user, "", null, null, msg, LogSucceed.FAIL, info, "");
                try {
                    securityLogMapper.insert((Object)sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u5f02\u5e38\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }
}

