/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.license.model.LicenseRecord;
import com.jxdinfo.hussar.core.support.LicenseInfo;
import com.jxdinfo.hussar.core.util.DateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/license"})
public class LicenseController
extends BaseController {
    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"license:view"})
    public String index(Model model) {
        String type = super.getPara("type");
        if ("1".equals(type)) {
            String appliCode = LicenseInfo.generateRequestSN();
            model.addAttribute("requestSN", (Object)appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                return "/core/license/errorLicense.html";
            }
            return "/core/license/noLicense.html";
        }
        if (this.isLicenseValid()) {
            LicenseRecord lr = new LicenseRecord();
            lr.setStartDate(DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy-MM-dd"));
            lr.setEndDate(DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy-MM-dd"));
            if (LicenseInfo.getLicenseType() == 0) {
                lr.setProjectName(LicenseInfo.getProjectName() + " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a" + LicenseInfo.getRequestLimit() + " >");
                lr.setLicenseType("\u5f00\u53d1\u73af\u5883\u6388\u6743");
                lr.setNeedLicense(true);
            } else if (LicenseInfo.getLicenseType() == 1) {
                lr.setProjectName(LicenseInfo.getProjectName());
                lr.setLicenseType("\u751f\u4ea7\u73af\u5883\u6388\u6743");
                lr.setNeedLicense(false);
            } else if (LicenseInfo.getLicenseType() == 2) {
                lr.setProjectName(LicenseInfo.getProjectName());
                lr.setLicenseType("VOL\u6279\u91cf\u6388\u6743");
                lr.setNeedLicense(false);
            }
            model.addAttribute("license", (Object)lr);
            return "/core/license/hasLicense.html";
        }
        String appliCode = LicenseInfo.generateRequestSN();
        model.addAttribute("requestSN", (Object)appliCode);
        if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
            return "/core/license/errorLicense.html";
        }
        return "/core/license/noLicense.html";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @ResponseBody
    public Tip uploadLicenseFile(@RequestPart(value="file") MultipartFile file) {
        try {
            File path = new File(LicenseInfo.TMP_PATH);
            if (!path.exists()) {
                path.mkdirs();
            }
            file.transferTo(new File(LicenseInfo.TMP_PATH + System.getProperty("file.separator") + file.getOriginalFilename()));
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        if (this.checkLicense()) {
            this.updateLicense();
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff01");
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/check"})
    @ResponseBody
    public Tip check() {
        boolean isTrial = LicenseInfo.isTrial();
        if (isTrial) {
            JSONObject json = new JSONObject();
            json.put("startDate", (Object)DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy.MM.dd"));
            json.put("endDate", (Object)DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy.MM.dd"));
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), json.toJSONString());
        }
        return SUCCESS_TIP;
    }

    private boolean isLicenseValid() {
        return LicenseInfo.isLicenseValidity();
    }

    private boolean checkLicense() {
        return LicenseInfo.checkLicense();
    }

    private void updateLicense() {
        LicenseInfo.update();
    }
}

