/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.persistence.dao.UsersMapper;
import com.jxdinfo.hussar.common.persistence.model.SysUsers;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class KickoutSessionFilter
extends AccessControlFilter {
    private String kickoutUrl;
    private SessionManager sessionManager;

    public void setKickoutUrl(String kickoutUrl) {
        this.kickoutUrl = kickoutUrl;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)request);
        HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
        Subject subject = this.getSubject(request, response);
        if (!subject.isAuthenticated() && !subject.isRemembered()) {
            if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
                httpServletResponse.setHeader("sessionstatus", "timeout");
                return false;
            }
            String referer = httpServletRequest.getHeader("Referer");
            if (referer == null) {
                this.saveRequestAndRedirectToLogin(request, response);
                return false;
            }
            if (ShiroKit.getSession().getAttribute((Object)"sessionFlag") == null) {
                httpServletRequest.setAttribute("tips", (Object)"");
                httpServletRequest.getRequestDispatcher("/login.html").forward(request, response);
                return false;
            }
            this.saveRequestAndRedirectToLogin(request, response);
            return false;
        }
        GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (globalProperties.isSessionLimit()) {
            UsersMapper usersMapper = (UsersMapper)SpringContextHolder.getBean(UsersMapper.class);
            SessionLimit sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class);
            Session session = subject.getSession();
            ShiroUser shiroUser = ShiroKit.getUser();
            SysUsers sysUser = (SysUsers)((Object)usersMapper.selectById((Serializable)((Object)shiroUser.getId())));
            String userId = shiroUser.getId();
            Serializable sessionId = session.getId();
            if (sysUser.getMaxSessions().intValue() != -1) {
                Deque<Serializable> deque = sessionLimit.getUserSession(userId);
                if (!deque.contains(sessionId) && session.getAttribute((Object)"kickout") == null) {
                    deque.push(sessionId);
                    sessionLimit.addUserSession(userId, deque);
                }
                if (deque.size() > sysUser.getMaxSessions().intValue()) {
                    Serializable kickoutSessionId = null;
                    kickoutSessionId = globalProperties.isKickoutAfter() ? deque.removeFirst() : deque.removeLast();
                    sessionLimit.addUserSession(userId, deque);
                    Session kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                    if (kickoutSession != null) {
                        kickoutSession.setAttribute((Object)"kickout", (Object)true);
                    }
                }
            }
            if ((Boolean)session.getAttribute((Object)"kickout") != null && ((Boolean)session.getAttribute((Object)"kickout")).booleanValue()) {
                subject.logout();
                if ("XMLHttpRequest".equalsIgnoreCase(((HttpServletRequest)request).getHeader("X-Requested-With"))) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", "300");
                    resultMap.put("message", "\u60a8\u5df2\u7ecf\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
                    this.out(response, resultMap);
                } else {
                    httpServletRequest.setAttribute("tips", (Object)"\u60a8\u5df2\u5728\u522b\u5904\u767b\u9646\uff01");
                    httpServletRequest.getRequestDispatcher("/login.html").forward(request, response);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private void out(ServletResponse hresponse, Map<String, String> resultMap) throws IOException {
        hresponse.setCharacterEncoding("UTF-8");
        PrintWriter out = hresponse.getWriter();
        out.println(JSON.toJSONString(resultMap));
        out.flush();
        out.close();
    }
}

