/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.encrypt;

import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.encrypt.AbstractCryptoProvider;
import com.jxdinfo.hussar.core.encrypt.condition.RSACondition;
import com.jxdinfo.hussar.core.util.RSAEncrypUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={RSACondition.class})
public class RSACryptoProvider
extends AbstractCryptoProvider {
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);

    @Override
    public String encode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return RSAEncrypUtil.encrypt(key, data);
    }

    @Override
    public String decode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return RSAEncrypUtil.decrypt(key, data);
    }

    @Override
    public Map<String, String> getKeyMap() {
        String publicKey = (String)hussarCacheManager.getObject("RSA", "RSAPublicKey");
        String privateKey = (String)hussarCacheManager.getObject("RSA", "RSAPrivateKey");
        if (publicKey == null || privateKey == null) {
            Map<String, Object> keyMap = RSAEncrypUtil.genKeyPair();
            hussarCacheManager.setObject("RSA", "RSAPublicKey", keyMap.get("RSAPublicKey"));
            hussarCacheManager.setObject("RSA", "RSAPrivateKey", keyMap.get("RSAPrivateKey"));
            publicKey = (String)hussarCacheManager.getObject("RSA", "RSAPublicKey");
            privateKey = (String)hussarCacheManager.getObject("RSA", "RSAPrivateKey");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("publicKey", publicKey);
        map.put("privateKey", privateKey);
        return map;
    }
}

