/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.jxdinfo.hussar.common.annotion.Permission;
import com.jxdinfo.hussar.core.shiro.check.PermissionCheckManager;
import java.lang.reflect.Method;
import javax.naming.NoPermissionException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=200)
public class PermissionAop {
    @Pointcut(value="@annotation(com.jxdinfo.hussar.common.annotion.Permission)")
    private void cutPermission() {
    }

    @Around(value="cutPermission()")
    public Object doPermission(ProceedingJoinPoint point) throws Throwable {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Permission permission = method.getAnnotation(Permission.class);
        Object[] permissions = permission.value();
        if (permissions == null || permissions.length == 0) {
            boolean result = PermissionCheckManager.checkAll();
            if (result) {
                return point.proceed();
            }
            throw new NoPermissionException();
        }
        boolean result = PermissionCheckManager.check(permissions);
        if (result) {
            return point.proceed();
        }
        throw new NoPermissionException();
    }
}

