/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.base.AbstractDictMap;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAop {
    private Logger log = LoggerFactory.getLogger(LogAop.class);

    @Pointcut(value="@annotation(com.jxdinfo.hussar.common.annotion.BussinessLog)")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object recordSysLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        try {
            this.handle(point);
        }
        catch (Exception e) {
            this.log.error("\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    private void handle(ProceedingJoinPoint point) throws Exception {
        String msg;
        Signature sig = point.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        msig = (MethodSignature)sig;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        String methodName = currentMethod.getName();
        ShiroUser user = ShiroKit.getUser();
        if (null == user) {
            return;
        }
        String className = point.getTarget().getClass().getName();
        Object[] params = point.getArgs();
        BussinessLog annotation = currentMethod.getAnnotation(BussinessLog.class);
        String bussinessName = annotation.value();
        String key = annotation.key();
        String type = annotation.type();
        Class<? extends AbstractDictMap> dictClass = annotation.dict();
        Class<?> logClass = annotation.logMsg();
        Object object = logClass.newInstance();
        String pk = annotation.pk();
        StringBuilder sb = new StringBuilder();
        for (Object param : params) {
            sb.append(param);
            sb.append(" & ");
        }
        if (bussinessName.indexOf("\u4fee\u6539") != -1 || bussinessName.indexOf("\u7f16\u8f91") != -1) {
            Object obj1 = LogObjectHolder.me().get();
            Map obj2 = HttpKit.getRequestParameters();
            Method m1 = logClass.getMethod("contrastObj", Class.class, String.class, Object.class, Map.class);
            msg = (String)m1.invoke(object, dictClass, pk, obj1, obj2);
        } else {
            Map parameters = HttpKit.getRequestParameters();
            AbstractDictMap dictMap = dictClass.newInstance();
            Method m2 = logClass.getMethod("getObjInfo", AbstractDictMap.class, String.class, Map.class);
            msg = (String)m2.invoke(object, dictMap, pk, parameters);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        info.put("sessionId", HttpKit.getSeesionId());
        HussarLogManager.me().executeLog(LogTaskFactory.bussinessLog(user, bussinessName, className, methodName, msg, info, key, type));
    }
}

