/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.common.annotion.IsRepeatAuthenticate;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.exception.IsRepeatAuthenticateException;
import com.jxdinfo.hussar.common.persistence.dao.UsersMapper;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.UnauthorizedException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class IsRepeatAuthenticateAop {
    @Resource
    private UsersMapper isSysUsersService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @Pointcut(value="@annotation(com.jxdinfo.hussar.common.annotion.IsRepeatAuthenticate)")
    public void repeat() {
    }

    @Around(value="repeat()")
    public Object recordSysLog(ProceedingJoinPoint point) throws Throwable {
        IsRepeatAuthenticate annotation;
        String permission;
        Signature sig = point.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        msig = (MethodSignature)sig;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String cipher = request.getParameter("cipher").trim();
        cipher = CryptoUtil.decode(cipher);
        ShiroUser shiroUser = ShiroKit.getUser();
        String userPermission = ConstantFactory.me().getAuthInfo(shiroUser).get("repeatAuthenticate").toString();
        if (userPermission.indexOf(permission = (annotation = currentMethod.getAnnotation(IsRepeatAuthenticate.class)).permission()) == -1) {
            throw new UnauthorizedException();
        }
        if (ToolUtil.isEmpty((Object)cipher)) {
            throw new IsRepeatAuthenticateException();
        }
        String tokenCredentials = this.credentialsMatcher.passwordEncode(String.valueOf(cipher).getBytes());
        int count = this.isSysUsersService.selectCount(new EntityWrapper().eq("USER_ID", (Object)ShiroKit.getUser().getId()).eq("PASSWORD", (Object)tokenCredentials));
        if (count != 0) {
            return point.proceed();
        }
        throw new IsRepeatAuthenticateException();
    }
}

