/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.aop;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.common.exception.IsRepeatAuthenticateException;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
@Order(value=-1)
public class GlobalExceptionHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    private void writeBussinessLog(String msg) {
        String username = HttpKit.getRequest().getParameter("username");
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            HussarLogManager.me().executeLog(LogTaskFactory.loginLog(username, msg, "07", info));
        }
    }

    @ExceptionHandler(value={HussarException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorTip notFount(HussarException e) {
        HussarLogManager.me().executeLog(LogTaskFactory.exceptionLog(ShiroKit.getUser(), (Exception)e));
        HttpKit.getRequest().setAttribute("tip", (Object)e.getMessage());
        this.log.error("\u4e1a\u52a1\u5f02\u5e38:", (Throwable)e);
        return new ErrorTip(e.getCode().intValue(), e.getMessage());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public String unAuth(AuthenticationException e) {
        this.log.error("\u7528\u6237\u672a\u767b\u9646\uff1a", (Throwable)e);
        return "/login.html";
    }

    @ExceptionHandler(value={DisabledAccountException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject accountFrozen(DisabledAccountException e, Model model) {
        this.writeBussinessLog("\u8d26\u53f7\u88ab\u51bb\u7ed3");
        JSONObject json = new JSONObject();
        json.put("result", (Object)"\u8d26\u53f7\u88ab\u51bb\u7ed3");
        return json;
    }

    @ExceptionHandler(value={LockedAccountException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject accountLocked(LockedAccountException e, Model model) {
        this.writeBussinessLog("\u8d26\u53f7\u88ab\u9501\u5b9a");
        JSONObject json = new JSONObject();
        json.put("result", (Object)"\u8d26\u53f7\u88ab\u9501\u5b9a");
        return json;
    }

    @ExceptionHandler(value={CredentialsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JSONObject credentials(CredentialsException e, Model model) {
        this.writeBussinessLog("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        JSONObject json = new JSONObject();
        if (ToolUtil.isEmpty((Object)e.getMessage())) {
            json.put("result", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        } else {
            json.put("result", (Object)("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c" + e.getMessage()));
        }
        return json;
    }

    @ExceptionHandler(value={InvalidKaptchaException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public JSONObject credentials(InvalidKaptchaException e, Model model) {
        this.writeBussinessLog("\u9a8c\u8bc1\u7801\u9519\u8bef");
        JSONObject json = new JSONObject();
        json.put("result", (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        return json;
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public ErrorTip credentials(UndeclaredThrowableException e) {
        HttpKit.getRequest().setAttribute("tip", (Object)"\u6743\u9650\u5f02\u5e38");
        this.log.error("\u6743\u9650\u5f02\u5e38!", (Throwable)e);
        return new ErrorTip(BizExceptionEnum.NO_PERMITION.getCode().intValue(), BizExceptionEnum.NO_PERMITION.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Object notFount(RuntimeException e) {
        HussarLogManager.me().executeLog(LogTaskFactory.exceptionLog(ShiroKit.getUser(), e));
        HttpKit.getRequest().setAttribute("tip", (Object)"\u670d\u52a1\u5668\u672a\u77e5\u8fd0\u884c\u65f6\u5f02\u5e38");
        this.log.error("\u8fd0\u884c\u65f6\u5f02\u5e38:", (Throwable)e);
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
            ModelAndView mav = new ModelAndView();
            mav.setViewName("/500.html");
            return mav;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/500.html");
        return mav;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object credentials(UnauthorizedException e) {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
            JSONObject json = new JSONObject();
            json.put("result", (Object)"NOPERMISSION");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/403.html");
        return mav;
    }

    @ExceptionHandler(value={IsRepeatAuthenticateException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object isRepeat(IsRepeatAuthenticateException e) {
        JSONObject json = new JSONObject();
        json.put("result", (Object)"NOTREPEATAUTHENTICATE");
        return json;
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Object unLogin(UnauthenticatedException e) {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
        if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
            JSONObject json = new JSONObject();
            json.put("result", (Object)"UNAUTHENTICATED");
            return json;
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("/login.html");
        return mav;
    }
}

