/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.BeanTypeAutoProxyCreator;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import com.jxdinfo.hussar.common.firewall.xss.XssFilter;
import com.jxdinfo.hussar.config.properties.ConnectionPoolProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.listener.ConfigListener;
import java.io.IOException;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestContextListener;

@Configuration
public class WebConfig {
    @Autowired
    private HussarProperties hussarProperties;
    @Autowired
    ConnectionPoolProperties connectionPoolProperties;

    @Bean
    public ServletRegistrationBean druidServletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[0]);
        registration.addUrlMappings(new String[]{"/druid/*"});
        if (this.connectionPoolProperties.isNeedLogin()) {
            registration.addInitParameter("loginUsername", this.connectionPoolProperties.getLoginUsername());
            registration.addInitParameter("loginPassword", this.connectionPoolProperties.getLoginPassword());
        }
        return registration;
    }

    @Bean
    public FilterRegistrationBean druidStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "/logout,/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid,/druid/*");
        filterRegistrationBean.addInitParameter("principalSessionName", "username");
        return filterRegistrationBean;
    }

    @Bean
    public DruidStatInterceptor druidStatInterceptor() {
        return new DruidStatInterceptor();
    }

    @Bean
    public JdkRegexpMethodPointcut druidStatPointcut() {
        JdkRegexpMethodPointcut druidStatPointcut = new JdkRegexpMethodPointcut();
        String patterns = "com.jxdinfo.hussar.*.service.*";
        druidStatPointcut.setPatterns(new String[]{patterns});
        return druidStatPointcut;
    }

    @Bean
    public BeanTypeAutoProxyCreator beanTypeAutoProxyCreator() {
        BeanTypeAutoProxyCreator beanTypeAutoProxyCreator = new BeanTypeAutoProxyCreator();
        beanTypeAutoProxyCreator.setTargetBeanType(DruidDataSource.class);
        beanTypeAutoProxyCreator.setInterceptorNames(new String[]{"druidStatInterceptor"});
        return beanTypeAutoProxyCreator;
    }

    @Bean
    public Advisor druidStatAdvisor() {
        return new DefaultPointcutAdvisor((Pointcut)this.druidStatPointcut(), (Advice)this.druidStatInterceptor());
    }

    @Bean
    public FilterRegistrationBean xssFilterRegistration() {
        XssFilter xssFilter = new XssFilter();
        xssFilter.setXssLevel(this.hussarProperties.getFirewallXssLevel());
        xssFilter.setUrlExclusion(this.hussarProperties.getXssWhitelist());
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)xssFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<RequestContextListener> requestContextListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new RequestContextListener());
    }

    @Bean
    public ServletListenerRegistrationBean<ConfigListener> configListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new ConfigListener());
    }

    @Bean
    public DefaultKaptcha kaptcha() throws IOException {
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource("/kaptcha.properties"));
        propertiesFactoryBean.afterPropertiesSet();
        Config config = new Config(propertiesFactoryBean.getObject());
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }
}

