/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.isc.listener.AdapterFactoryListener;
import com.jxdinfo.hussar.isc.util.CasClient;
import io.buji.pac4j.context.ShiroSessionStore;
import java.util.EventListener;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroPac4jConfig {
    @Autowired
    private ShiroIscConfiguration iscConf;

    @Bean(value={"authcConfig"})
    public Config config(CasClient casClient, ShiroSessionStore shiroSessionStore) {
        Config config = new Config((Client)casClient);
        config.setSessionStore((SessionStore)shiroSessionStore);
        return config;
    }

    @Bean
    public ShiroSessionStore shiroSessionStore() {
        return new ShiroSessionStore();
    }

    @Bean
    public CasClient casClient(CasConfiguration casConfig) {
        CasClient casClient = new CasClient(casConfig);
        casClient.setCallbackUrl(this.iscConf.getLocalUrl() + "/callback?client_name=" + this.iscConf.getClientName());
        casClient.setName(this.iscConf.getClientName());
        return casClient;
    }

    @Bean
    public CasConfiguration casConfig() {
        CasConfiguration configuration = new CasConfiguration();
        configuration.setLoginUrl(this.iscConf.getServerLoginUrl());
        configuration.setProtocol(CasProtocol.CAS20);
        configuration.setAcceptAnyProxy(true);
        configuration.setPrefixUrl(this.iscConf.getServerUrlPrefix());
        return configuration;
    }

    @Bean
    public ServletListenerRegistrationBean<AdapterFactoryListener> adapterFactoryListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)((Object)new AdapterFactoryListener()));
    }
}

