/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.alibaba.druid.util.StringUtils;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.config.properties.ShiroProperties;
import com.jxdinfo.hussar.core.intercept.HussarUserFilter;
import com.jxdinfo.hussar.core.intercept.KickoutSessionFilter;
import com.jxdinfo.hussar.core.shiro.HussarSessionListener;
import com.jxdinfo.hussar.core.shiro.ShiroDbRealm;
import com.jxdinfo.hussar.core.shiro.ShiroPac4jRealm;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.rest.config.properties.JwtProperties;
import com.jxdinfo.hussar.rest.config.properties.RestProperties;
import io.buji.pac4j.filter.CallbackFilter;
import io.buji.pac4j.filter.LogoutFilter;
import io.buji.pac4j.filter.SecurityFilter;
import io.buji.pac4j.subject.Pac4jSubjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.pac4j.core.config.Config;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
public class ShiroConfig {
    @Value(value="${spring.profiles.active}")
    private String active;
    @Autowired
    private ShiroProperties shiroProperties;
    @Autowired
    private JwtProperties jwtProperties;
    @Autowired
    private RestProperties restProperties;
    @Autowired
    private CredentialsMatcher credentialsMatcher;
    @Autowired
    private ShiroIscConfiguration iscConf;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private HussarProperties hussarProperties;
    @Autowired
    private GlobalProperties globalProperties;

    @Bean
    public DefaultWebSecurityManager securityManager(CookieRememberMeManager rememberMeManager, CacheManager cacheShiroManager, SessionManager sessionManager, Realm realm, Pac4jSubjectFactory subjectFactory) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm(realm);
        if (this.iscConf.isActive()) {
            securityManager.setSubjectFactory((SubjectFactory)subjectFactory);
        } else {
            securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
        }
        securityManager.setSessionManager(sessionManager);
        securityManager.setCacheManager(cacheShiroManager);
        return securityManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"spring-session-open"}, havingValue="true")
    public ServletContainerSessionManager servletContainerSessionManager() {
        return new ServletContainerSessionManager();
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"spring-session-open"}, havingValue="false")
    public DefaultWebSessionManager defaultWebSessionManager(CacheManager cacheShiroManager, Collection<SessionListener> listeners, SessionDAO sessionDAO) {
        int kilo = 1000;
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionValidationInterval((long)(this.hussarProperties.getSessionValidationInterval() * kilo));
        sessionManager.setGlobalSessionTimeout((long)(this.hussarProperties.getSessionInvalidateTime() * kilo));
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        sessionManager.setSessionListeners(listeners);
        sessionManager.setCacheManager(cacheShiroManager);
        sessionManager.setSessionDAO(sessionDAO);
        sessionManager.setSessionIdCookieEnabled(true);
        SimpleCookie cookie = new SimpleCookie(this.globalProperties.getTitle() + "_hussarShiroCookie");
        cookie.setHttpOnly(true);
        sessionManager.setSessionIdCookie((Cookie)cookie);
        return sessionManager;
    }

    @Bean
    public SessionDAO sessionDAO() {
        MemorySessionDAO sessionDAO = null;
        if (this.hussarProperties.isStandAlone()) {
            sessionDAO = new MemorySessionDAO();
        } else {
            sessionDAO = new RedisSessionDAO();
            ((RedisSessionDAO)sessionDAO).setRedisManager(this.redisManager());
        }
        return sessionDAO;
    }

    @Bean
    public CacheManager cacheShiroManager() {
        RedisCacheManager cacheManager = null;
        if (!this.hussarProperties.isStandAlone()) {
            cacheManager = new RedisCacheManager();
            cacheManager.setRedisManager(this.redisManager());
        }
        return cacheManager;
    }

    public RedisManager redisManager() {
        RedisManager redisManager = new RedisManager();
        redisManager.setHost(this.redisProperties.getHost());
        redisManager.setPort(this.redisProperties.getPort());
        redisManager.setTimeout(this.redisProperties.getTimeout());
        redisManager.setExpire(this.hussarProperties.getSessionValidationInterval().intValue());
        redisManager.setPassword(this.redisProperties.getPassword());
        return redisManager;
    }

    @Bean
    public Collection<SessionListener> getSessionListener() {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>();
        listeners.add(new HussarSessionListener());
        return listeners;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager(SimpleCookie rememberMeCookie) {
        CookieRememberMeManager manager = new CookieRememberMeManager();
        manager.setCipherKey(Base64.decode((String)"SHVzc2FyVjgAAAAAAAAAA="));
        manager.setCookie((Cookie)rememberMeCookie);
        return manager;
    }

    @Bean
    public CredentialsMatcher credentialsMatcher() {
        return this.credentialsMatcher;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie(this.globalProperties.getTitle() + "_rememberMe");
        simpleCookie.setHttpOnly(true);
        int time = 604800;
        simpleCookie.setMaxAge(time);
        return simpleCookie;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(DefaultWebSecurityManager securityManager, CacheManager cacheShiroManager, DefaultWebSessionManager sessionManager, Config config) {
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager((SecurityManager)securityManager);
        String loginUrl = this.shiroProperties.getLoginUrl();
        if (StringUtils.isEmpty((String)loginUrl)) {
            loginUrl = "/login";
        }
        shiroFilter.setLoginUrl(loginUrl);
        String successUrl = this.shiroProperties.getSuccessUrl();
        if (StringUtils.isEmpty((String)successUrl)) {
            successUrl = "/";
        }
        shiroFilter.setSuccessUrl(successUrl);
        String unauthorizedUrl = this.shiroProperties.getUnauthorizedUrl();
        if (StringUtils.isEmpty((String)unauthorizedUrl)) {
            unauthorizedUrl = "/global/403";
        }
        shiroFilter.setUnauthorizedUrl(unauthorizedUrl);
        HashMap<String, Object> filters = new HashMap<String, Object>();
        if (this.iscConf.isActive()) {
            SecurityFilter securityFilter = new SecurityFilter();
            securityFilter.setConfig(config);
            securityFilter.setClients(this.iscConf.getClientName());
            filters.put("securityFilter", securityFilter);
            CallbackFilter callbackFilter = new CallbackFilter();
            callbackFilter.setConfig(config);
            callbackFilter.setDefaultUrl(this.iscConf.getLocalUrl());
            filters.put("callbackFilter", callbackFilter);
            LogoutFilter logoutFilter = new LogoutFilter();
            logoutFilter.setConfig(config);
            logoutFilter.setCentralLogout(Boolean.valueOf(true));
            logoutFilter.setLocalLogout(Boolean.valueOf(true));
            logoutFilter.setDefaultUrl(this.iscConf.getLocalUrl() + "/callback?client_name=" + this.iscConf.getClientName());
            filters.put("logoutFilter", logoutFilter);
        } else {
            filters.put("user", (Object)new HussarUserFilter());
            filters.put("kickout", (Object)this.kickoutSessionFilter(sessionManager));
        }
        shiroFilter.setFilters(filters);
        this.loadShiroFilterChain(shiroFilter, this.iscConf.isActive());
        return shiroFilter;
    }

    @Bean
    public MethodInvokingFactoryBean methodInvokingFactoryBean(DefaultWebSecurityManager securityManager) {
        MethodInvokingFactoryBean bean = new MethodInvokingFactoryBean();
        bean.setStaticMethod("org.apache.shiro.SecurityUtils.setSecurityManager");
        bean.setArguments(new Object[]{securityManager});
        return bean;
    }

    @Bean
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    public KickoutSessionFilter kickoutSessionFilter(DefaultWebSessionManager sessionManager) {
        KickoutSessionFilter kickoutSessionFilter = new KickoutSessionFilter();
        kickoutSessionFilter.setSessionManager((SessionManager)sessionManager);
        kickoutSessionFilter.setKickoutUrl("/login");
        return kickoutSessionFilter;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new DelegatingFilterProxy("shiroFilter"));
        filterRegistration.addInitParameter("targetFilterLifecycle", "true");
        filterRegistration.setEnabled(true);
        filterRegistration.addUrlPatterns(new String[]{"/*"});
        filterRegistration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD});
        return filterRegistration;
    }

    @Bean
    public Pac4jSubjectFactory subjectFactory() {
        return new Pac4jSubjectFactory();
    }

    @Bean
    public Realm realm(@Qualifier(value="credentialsMatcher") CredentialsMatcher matcher) {
        if (this.iscConf.isActive()) {
            ShiroPac4jRealm realm = new ShiroPac4jRealm();
            realm.setClientName(this.iscConf.getClientName());
            realm.setCachingEnabled(false);
            realm.setAuthenticationCachingEnabled(false);
            realm.setAuthorizationCachingEnabled(false);
            return realm;
        }
        ShiroDbRealm shiroDbRealm = new ShiroDbRealm();
        shiroDbRealm.setCredentialsMatcher(matcher);
        return shiroDbRealm;
    }

    private void loadShiroFilterChain(ShiroFilterFactoryBean shiroFilterFactoryBean, Boolean isIsc) {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        if ("dev".equals(this.active)) {
            if (isIsc.booleanValue()) {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/callback", "callbackFilter");
                filterChainDefinitionMap.put("/logout", "logoutFilter");
                filterChainDefinitionMap.put("/", "securityFilter");
            }
            filterChainDefinitionMap.put("/**", "anon");
        } else {
            filterChainDefinitionMap.put(this.jwtProperties.getAuthPath(), "anon");
            filterChainDefinitionMap.put(this.restProperties.getUrlPattern(), "anon");
            List<String> securityWhitelist = this.shiroProperties.getSecurityWhitelist();
            if (securityWhitelist != null) {
                for (String string : securityWhitelist) {
                    if (filterChainDefinitionMap.containsKey(string)) continue;
                    filterChainDefinitionMap.put(string, "anon");
                }
            }
            if (isIsc.booleanValue()) {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/callback", "callbackFilter");
                filterChainDefinitionMap.put("/logout", "logoutFilter");
                filterChainDefinitionMap.put("/", "securityFilter");
                filterChainDefinitionMap.put("/**", "securityFilter");
            } else {
                filterChainDefinitionMap.put("/static/**", "anon");
                filterChainDefinitionMap.put("/login", "anon");
                filterChainDefinitionMap.put("/getBackPwd/**", "anon");
                filterChainDefinitionMap.put("/global/sessionError", "anon");
                filterChainDefinitionMap.put("/kaptcha", "anon");
                filterChainDefinitionMap.put("/security", "anon");
                filterChainDefinitionMap.put("/**", "user");
                filterChainDefinitionMap.put("/**", "kickout");
            }
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
    }
}

