/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.jxdinfo.hussar.config.properties.HussarProperties;
import javax.annotation.Resource;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableCaching
public class HussarCacheConfig {
    @Resource
    private HussarProperties hussarProperties;

    @Bean
    public CacheManager cacheManager(RedisTemplate redisTemplate, EhCacheManagerFactoryBean ehCacheManagerFactoryBean) {
        EhCacheCacheManager cacheManager = null;
        if (this.hussarProperties.isStandAlone()) {
            cacheManager = new EhCacheCacheManager(ehCacheManagerFactoryBean.getObject());
        } else {
            int expire = 600;
            cacheManager = new RedisCacheManager((RedisOperations)redisTemplate);
            ((RedisCacheManager)cacheManager).setDefaultExpiration((long)expire);
        }
        return cacheManager;
    }
}

