/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.properties;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="beetl")
public class BeetlProperties {
    public static final String BEETLCONF_PREFIX = "beetl";
    private String delimiterStatementStart = "@";
    private String delimiterStatementEnd = "null";
    private String resourceTagroot = "common/tags";
    private String resourceTagsuffix = "tag";
    private String resourceAutoCheck = "true";
    private String htmlTagFlag = "hussar:";

    public Properties getProperties() {
        Properties properties = new Properties();
        if (ToolUtil.isNotEmpty((Object)this.delimiterStatementStart)) {
            if (this.delimiterStatementStart.startsWith("\\")) {
                this.delimiterStatementStart = this.delimiterStatementStart.substring(1);
            }
            properties.setProperty("DELIMITER_STATEMENT_START", this.delimiterStatementStart);
        }
        if (ToolUtil.isNotEmpty((Object)this.delimiterStatementEnd)) {
            properties.setProperty("DELIMITER_STATEMENT_END", this.delimiterStatementEnd);
        } else {
            properties.setProperty("DELIMITER_STATEMENT_END", "null");
        }
        if (ToolUtil.isNotEmpty((Object)this.resourceTagroot)) {
            properties.setProperty("RESOURCE.tagRoot", this.resourceTagroot);
        }
        if (ToolUtil.isNotEmpty((Object)this.resourceTagsuffix)) {
            properties.setProperty("RESOURCE.tagSuffix", this.resourceTagsuffix);
        }
        if (ToolUtil.isNotEmpty((Object)this.resourceAutoCheck)) {
            properties.setProperty("RESOURCE.autoCheck", this.resourceAutoCheck);
        }
        if (ToolUtil.isNotEmpty((Object)this.htmlTagFlag)) {
            properties.setProperty("HTML_TAG_FLAG", this.htmlTagFlag);
        } else {
            properties.setProperty("HTML_TAG_FLAG", "hussar:");
        }
        return properties;
    }

    public String getDelimiterStatementStart() {
        return this.delimiterStatementStart;
    }

    public void setDelimiterStatementStart(String delimiterStatementStart) {
        this.delimiterStatementStart = delimiterStatementStart;
    }

    public String getDelimiterStatementEnd() {
        return this.delimiterStatementEnd;
    }

    public void setDelimiterStatementEnd(String delimiterStatementEnd) {
        this.delimiterStatementEnd = delimiterStatementEnd;
    }

    public String getResourceTagroot() {
        return this.resourceTagroot;
    }

    public void setResourceTagroot(String resourceTagroot) {
        this.resourceTagroot = resourceTagroot;
    }

    public String getResourceTagsuffix() {
        return this.resourceTagsuffix;
    }

    public void setResourceTagsuffix(String resourceTagsuffix) {
        this.resourceTagsuffix = resourceTagsuffix;
    }

    public String getResourceAutoCheck() {
        return this.resourceAutoCheck;
    }

    public void setResourceAutoCheck(String resourceAutoCheck) {
        this.resourceAutoCheck = resourceAutoCheck;
    }

    public String getHtmlTagFlag() {
        return this.htmlTagFlag;
    }

    public void setHtmlTagFlag(String htmlTagFlag) {
        this.htmlTagFlag = htmlTagFlag;
    }
}

