/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config;

import com.alibaba.druid.filter.stat.MergeStatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.jxdinfo.hussar.config.properties.ConnectionPoolProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.datascope.DataScopeInterceptor;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import com.jxdinfo.hussar.core.mutidatasource.config.MutiDataSourceFourProperties;
import com.jxdinfo.hussar.core.mutidatasource.config.MutiDataSourceOneProperties;
import com.jxdinfo.hussar.core.mutidatasource.config.MutiDataSourceThreeProperties;
import com.jxdinfo.hussar.core.mutidatasource.config.MutiDataSourceTwoProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(order=2)
public class MybatisPlusConfig {
    private static Map<Object, Object> targetDataSource = new HashMap<Object, Object>();
    @Autowired
    DruidProperties druidProperties;
    @Autowired
    MutiDataSourceOneProperties mutiDataSourceOneProperties;
    @Autowired
    MutiDataSourceTwoProperties mutiDataSourceTwoProperties;
    @Autowired
    MutiDataSourceThreeProperties mutiDataSourceThreeProperties;
    @Autowired
    MutiDataSourceFourProperties mutiDataSourceFourProperties;
    @Autowired
    HussarProperties hussarProperties;
    @Autowired
    ConnectionPoolProperties connectionPoolProperties;

    public static void setTargetDataSource(String dataSourceKey, DruidDataSource druidDataSource) {
        targetDataSource.put(dataSourceKey, druidDataSource);
    }

    private DruidDataSource dataSourceOne() {
        DruidDataSource dataSource = null;
        if (!"".equals(this.mutiDataSourceOneProperties.getUrl())) {
            dataSource = new DruidDataSource();
            this.mutiDataSourceOneProperties.config(dataSource);
        }
        return dataSource;
    }

    private DruidDataSource dataSourceTwo() {
        DruidDataSource dataSource = null;
        if (!"".equals(this.mutiDataSourceTwoProperties.getUrl())) {
            dataSource = new DruidDataSource();
            this.mutiDataSourceTwoProperties.config(dataSource);
        }
        return dataSource;
    }

    private DruidDataSource dataSourceThree() {
        DruidDataSource dataSource = null;
        if (!"".equals(this.mutiDataSourceThreeProperties.getUrl())) {
            dataSource = new DruidDataSource();
            this.mutiDataSourceThreeProperties.config(dataSource);
        }
        return dataSource;
    }

    private DruidDataSource dataSourceFour() {
        DruidDataSource dataSource = null;
        if (!"".equals(this.mutiDataSourceFourProperties.getUrl())) {
            dataSource = new DruidDataSource();
            this.mutiDataSourceFourProperties.config(dataSource);
        }
        return dataSource;
    }

    private DataSource getJNDIDataSource(String JNDIName) {
        DataSource dataSource = null;
        if (this.hussarProperties.getUseJNDI().booleanValue() && ToolUtil.isNotEmpty((Object)JNDIName)) {
            JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
            dataSourceLookup.setResourceRef(true);
            dataSource = dataSourceLookup.getDataSource(JNDIName);
        }
        return dataSource;
    }

    private DataSource dataSourceJNDIOne() {
        String JNDIName = this.mutiDataSourceOneProperties.getJndiName();
        return this.getJNDIDataSource(JNDIName);
    }

    private DataSource dataSourceJNDITwo() {
        String JNDIName = this.mutiDataSourceTwoProperties.getJndiName();
        return this.getJNDIDataSource(JNDIName);
    }

    private DataSource dataSourceJNDIThree() {
        String JNDIName = this.mutiDataSourceThreeProperties.getJndiName();
        return this.getJNDIDataSource(JNDIName);
    }

    private DataSource dataSourceJNDIFour() {
        String JNDIName = this.mutiDataSourceFourProperties.getJndiName();
        return this.getJNDIDataSource(JNDIName);
    }

    public DruidDataSource dataSourceHussar() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.getProxyFilters().remove(MergeStatFilter.class);
        dataSource.getProxyFilters().add(this.mergeStatFilter());
        this.druidProperties.config(dataSource);
        return dataSource;
    }

    public DataSource dataSourceJNDI() {
        JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
        dataSourceLookup.setResourceRef(true);
        return dataSourceLookup.getDataSource(this.druidProperties.getJndiName());
    }

    @Bean
    public MergeStatFilter mergeStatFilter() {
        MergeStatFilter statFilter = new MergeStatFilter();
        statFilter.setSlowSqlMillis((long)this.connectionPoolProperties.getSlowSqlMillis());
        statFilter.setLogSlowSql(this.connectionPoolProperties.isLogSlowSql());
        statFilter.setMergeSql(this.connectionPoolProperties.isMergeSql());
        return statFilter;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"muti-datasource-open"}, havingValue="false", matchIfMissing=true)
    public DataSource singleDatasource() {
        if (this.hussarProperties.getUseJNDI().booleanValue()) {
            return this.dataSourceJNDI();
        }
        return this.dataSourceHussar();
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"muti-datasource-open"}, havingValue="true")
    public DataSource mutiDataSource() throws SQLException {
        HashMap<String, DataSource> hashMap = new HashMap<String, DataSource>();
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        if (this.hussarProperties.getUseJNDI().booleanValue()) {
            DataSource dataSourceJNDI = this.dataSourceJNDI();
            dynamicDataSource.setDefaultTargetDataSource(dataSourceJNDI);
            DataSource dataSourceOne = this.dataSourceJNDIOne();
            DataSource dataSourceTwo = this.dataSourceJNDITwo();
            DataSource dataSourceThree = this.dataSourceJNDIThree();
            DataSource dataSourceFour = this.dataSourceJNDIFour();
            hashMap.put("dataSourceHussar", dataSourceJNDI);
            if (null != dataSourceOne) {
                hashMap.put("dataSource-one", dataSourceOne);
            }
            if (null != dataSourceTwo) {
                hashMap.put("dataSource-two", dataSourceTwo);
            }
            if (null != dataSourceThree) {
                hashMap.put("dataSource-three", dataSourceThree);
            }
            if (null != dataSourceFour) {
                hashMap.put("dataSource-four", dataSourceFour);
            }
        } else {
            DruidDataSource dataSourceHussar = this.dataSourceHussar();
            dynamicDataSource.setDefaultTargetDataSource(dataSourceHussar);
            DruidDataSource dataSourceOne = this.dataSourceOne();
            DruidDataSource dataSourceTwo = this.dataSourceTwo();
            DruidDataSource dataSourceThree = this.dataSourceThree();
            DruidDataSource dataSourceFour = this.dataSourceFour();
            dataSourceHussar.init();
            hashMap.put("dataSourceHussar", (DataSource)dataSourceHussar);
            if (null != dataSourceOne) {
                dataSourceOne.init();
                hashMap.put("dataSource-one", (DataSource)dataSourceOne);
            }
            if (null != dataSourceTwo) {
                dataSourceTwo.init();
                hashMap.put("dataSource-two", (DataSource)dataSourceTwo);
            }
            if (null != dataSourceThree) {
                dataSourceThree.init();
                hashMap.put("dataSource-three", (DataSource)dataSourceThree);
            }
            if (null != dataSourceFour) {
                dataSourceFour.init();
                hashMap.put("dataSource-four", (DataSource)dataSourceFour);
            }
        }
        dynamicDataSource.setTargetDataSources(hashMap);
        return dynamicDataSource;
    }

    @Bean
    public PaginationInterceptor paginationInterceptor(DataSource dataSource) throws SQLException {
        PaginationInterceptor inter = new PaginationInterceptor();
        Connection connection = dataSource.getConnection();
        String url = connection.getMetaData().getURL();
        String driverClassName = connection.getMetaData().getDriverName();
        connection.close();
        if (url.startsWith("jdbc:dm")) {
            inter.setDialectClazz("com.jxdinfo.hussar.pagination.dialects.DMDialect");
        }
        if (url.startsWith("jdbc:oscar")) {
            inter.setDialectClazz("com.jxdinfo.hussar.pagination.dialects.OSCARDialect");
        }
        if (url.startsWith("jdbc:kingbase")) {
            inter.setDialectClazz("com.jxdinfo.hussar.pagination.dialects.KingbaseDialect");
        }
        return inter;
    }

    @Bean
    public DataScopeInterceptor dataScopeInterceptor() {
        return new DataScopeInterceptor();
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }
}

