/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.projecttool;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class IDCardUtil {
    private static String errorInfo;
    private static final int OLD_LENGTH = 15;
    private static final int NEW_LENGTH = 18;
    private static final int[] WI;
    private static final int[] VI;
    private static int[] ai;
    private static String[] areaCode;
    private static HashMap<String, String> areaCodeMap;
    private static final String BIRTH_DATE_FORMAT = "yyyyMMdd";
    private static final Date MINIMAL_BIRTH_DATE;

    public static boolean checkCardId(String cardId) {
        errorInfo = "";
        if (!IDCardUtil.checkLength(cardId)) {
            return false;
        }
        if (!IDCardUtil.allIsNumber(cardId)) {
            return false;
        }
        String cardIdNew = "";
        cardIdNew = cardId.length() == 15 ? IDCardUtil.changeToEighteen(cardId) : cardId;
        if (!IDCardUtil.checkAreaCode(cardIdNew)) {
            return false;
        }
        if (!IDCardUtil.checkBirthdayCode(cardIdNew)) {
            return false;
        }
        return IDCardUtil.checkMOD(cardIdNew);
    }

    private static boolean checkLength(String cardId) {
        int length = cardId.length();
        if (length == 15 || length == 18) {
            return true;
        }
        errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u4e0d\u662f15\u4f4d\u621618\u4f4d\u7684\uff01";
        return false;
    }

    private static boolean checkAreaCode(String cardId) {
        String areaCode = cardId.substring(0, 2);
        if (areaCodeMap.containsKey(areaCode)) {
            return true;
        }
        errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u7684\u5730\u533a\u7801(1-2\u4f4d)[" + areaCode + "]\u4e0d\u7b26\u5408\u4e2d\u56fd\u884c\u653f\u533a\u5212\u5206\u4ee3\u7801\u89c4\u5b9a(GB/T2260-1999)\uff01";
        return false;
    }

    private static boolean checkBirthdayCode(String cardId) {
        Date birthDate = new Date();
        try {
            birthDate = new SimpleDateFormat(BIRTH_DATE_FORMAT).parse(cardId.substring(6, 14));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (birthDate.after(new Date()) || birthDate.before(MINIMAL_BIRTH_DATE)) {
            errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u51fa\u751f\u65e5\u671f\u4e0d\u6b63\u786e";
            return false;
        }
        String birthday = cardId.substring(6, 14);
        Date realBirthday = IDCardUtil.toBirthDay(birthday);
        String realBirthdayStr = new SimpleDateFormat(BIRTH_DATE_FORMAT).format(realBirthday);
        if (realBirthday == null || !birthday.equals(realBirthdayStr)) {
            errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u51fa\u751f\u65e5\u671f\u4e0d\u6b63\u786e";
            return false;
        }
        return true;
    }

    private static Date toBirthDay(String birthday) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(birthday.substring(0, 4)));
        calendar.set(2, Integer.parseInt(birthday.substring(4, 6)) - 1);
        calendar.set(5, Integer.parseInt(birthday.substring(6, 8)));
        return calendar.getTime();
    }

    private static boolean allIsNumber(String cardId) {
        String str = "";
        if (cardId.length() == 15) {
            str = cardId.substring(0, 15);
        } else if (cardId.length() == 18) {
            str = cardId.substring(0, 17);
        }
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') continue;
            errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u7b2c" + (i + 1) + "\u4f4d\u4e0d\u662f\u6570\u5b57\uff01";
            return false;
        }
        return true;
    }

    public String getCodeError() {
        return errorInfo;
    }

    private static boolean checkMOD(String cardId) {
        String verifyIndex;
        String verify = cardId.substring(17, 18);
        if ("x".equals(verify)) {
            cardId = cardId.replaceAll("x", "X");
            verify = "X";
        }
        if (verify.equals(verifyIndex = IDCardUtil.getVerify(cardId))) {
            return true;
        }
        int x = 17;
        if (cardId.length() == 15) {
            x = 14;
        }
        errorInfo = "\u9519\u8bef\uff1a\u8f93\u5165\u7684\u8eab\u4efd\u8bc1\u53f7\u6700\u540e\u4e00\u4f4d\u4e0d\u6b63\u786e\uff01";
        return false;
    }

    private static String getVerify(String cardId) {
        int remaining = 0;
        if (cardId.length() == 18) {
            cardId = cardId.substring(0, 17);
        }
        if (cardId.length() == 17) {
            int i;
            int sum = 0;
            for (i = 0; i < 17; ++i) {
                String k = cardId.substring(i, i + 1);
                IDCardUtil.ai[i] = Integer.parseInt(k);
            }
            for (i = 0; i < 17; ++i) {
                sum += WI[i] * ai[i];
            }
            remaining = sum % 11;
        }
        return remaining == 2 ? "X" : String.valueOf(VI[remaining]);
    }

    private static String changeToEighteen(String cardIdOld) {
        String cardIdNew = cardIdOld.substring(0, 6);
        cardIdNew = cardIdNew + "19";
        cardIdNew = cardIdNew + cardIdOld.substring(6, 15);
        cardIdNew = cardIdNew + IDCardUtil.getVerify(cardIdNew);
        return cardIdNew;
    }

    static {
        WI = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        VI = new int[]{1, 0, 88, 9, 8, 7, 6, 5, 4, 3, 2};
        ai = new int[18];
        areaCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
        MINIMAL_BIRTH_DATE = new Date(-2209017600000L);
        areaCodeMap = new HashMap();
        for (String str : areaCode) {
            areaCodeMap.put(str, null);
        }
    }
}

