/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.persistence.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.browserutil.GetBrowserUtil;
import com.jxdinfo.hussar.common.persistence.dao.OnlineHistMapper;
import com.jxdinfo.hussar.common.persistence.dao.StruMapper;
import com.jxdinfo.hussar.common.persistence.dao.UsersMapper;
import com.jxdinfo.hussar.common.persistence.model.SysOnlineHist;
import com.jxdinfo.hussar.common.persistence.model.SysUsers;
import com.jxdinfo.hussar.common.persistence.service.IOnlineHistService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.stereotype.Service;

@Service
public class OnlineHistServiceImpl
extends ServiceImpl<OnlineHistMapper, SysOnlineHist>
implements IOnlineHistService {
    @Resource
    private OnlineHistMapper onlineHistMapper;
    @Resource
    private UsersMapper usersMapper;
    @Resource
    private StruMapper struMapper;
    @Resource
    private GetBrowserUtil getBrowserUtil;

    @Override
    public Page<SysOnlineHist> getOnlineHistList(Page<SysOnlineHist> page, Timestamp startTime, Timestamp endTime, String userAccount) {
        page.setRecords(this.onlineHistMapper.getOnlineHistList(page, startTime, endTime, userAccount));
        return page;
    }

    @Override
    public void addRecord() {
        SysOnlineHist onlineHist;
        String sessionId = (String)((Object)ShiroKit.getSession().getId());
        String userId = (String)ShiroKit.getSession().getAttribute((Object)"userId");
        if (ToolUtil.isEmpty((Object)userId)) {
            return;
        }
        SysUsers sysUsers = (SysUsers)((Object)this.usersMapper.selectById((Serializable)((Object)userId)));
        Map<String, Object> dept = this.struMapper.getOrgInfoByOrgId(sysUsers.getDepartmentId());
        String deptName = "";
        if (ToolUtil.isNotEmpty(dept) && ToolUtil.isNotEmpty((Object)dept.get("SHORTNAME"))) {
            deptName = (String)dept.get("SHORTNAME");
        }
        if (ToolUtil.isEmpty((Object)((Object)(onlineHist = (SysOnlineHist)((Object)this.onlineHistMapper.selectById((Serializable)((Object)sessionId))))))) {
            SysOnlineHist sysOnlineHist = new SysOnlineHist();
            sysOnlineHist.setSessionId(sessionId);
            sysOnlineHist.setUserId(sysUsers.getUserId());
            sysOnlineHist.setUserAccount(sysUsers.getUserAccount());
            sysOnlineHist.setUserName(sysUsers.getUserName());
            sysOnlineHist.setCorporationId(sysUsers.getDepartmentId());
            sysOnlineHist.setCorporationName(deptName);
            sysOnlineHist.setLoginTime(new Timestamp(System.currentTimeMillis()));
            sysOnlineHist.setRemoteaddr(HttpKit.getIp());
            sysOnlineHist.setRemotehost(HttpKit.getHost());
            sysOnlineHist.setRemoteport(HttpKit.getPort());
            HttpServletRequest requestNew = WebUtils.toHttp((ServletRequest)HttpKit.getRequest());
            sysOnlineHist.setBrowserType(this.getBrowserUtil.getBrowser(requestNew));
            this.onlineHistMapper.insert((Object)sysOnlineHist);
        }
    }

    @Override
    public void updateLogoffTime() {
        String sessionId = (String)((Object)ShiroKit.getSession().getId());
        SysOnlineHist sysOnlineHist = (SysOnlineHist)((Object)this.onlineHistMapper.selectById((Serializable)((Object)sessionId)));
        if (ToolUtil.isNotEmpty((Object)((Object)sysOnlineHist))) {
            sysOnlineHist.setLogoffTime(new Timestamp(System.currentTimeMillis()));
            this.onlineHistMapper.updateById((Object)sysOnlineHist);
        }
    }
}

