/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.persistence.service.impl;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.persistence.dao.DicSingleMapper;
import com.jxdinfo.hussar.common.persistence.dao.DicTypeMapper;
import com.jxdinfo.hussar.common.persistence.model.DicType;
import com.jxdinfo.hussar.common.persistence.service.IDicSingleService;
import com.jxdinfo.hussar.common.persistence.service.IDicTypeService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.crazycake.shiro.SerializeUtils;
import org.springframework.stereotype.Service;

@Service
public class DicTypeServiceImpl
extends ServiceImpl<DicTypeMapper, DicType>
implements IDicTypeService {
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private DicTypeMapper dicTypeMapper;
    @Resource
    private DicSingleMapper singleMapper;
    @Resource
    private IDicSingleService dicSingleService;

    @Override
    public void evictTypeCacheById(String id) {
        DicType type = (DicType)((Object)this.selectById((Serializable)((Object)id)));
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:" + type.getTypeName() + ":*");
        }
    }

    @Override
    public List<JSTreeModel> dicExportTreeData() {
        return this.dicTypeMapper.dicExportTreeData();
    }

    @Override
    public void exportDict(List<String> idList, HttpServletResponse response) {
        List type = super.selectBatchIds(idList);
        List<String> singleIdList = this.getSingleIdByTypeId(idList, new ArrayList<String>());
        List single = this.dicSingleService.selectBatchIds(singleIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("export_type", "dictionary");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "dict_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    private List<String> getSingleIdByTypeId(List<String> typeIdList, List<String> resultList) {
        List<String> singleIdList = this.singleMapper.getSingleIdByTypeId(typeIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    @Override
    public Tip importDict(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("dictionary"));
        }
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        Map<String, Integer> count = this.insertOrUpdateList(type);
        this.dicSingleService.insertOrUpdateBatch(single, single.size());
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public Map<String, Integer> insertOrUpdateList(List<DicType> dicTypeList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(dicTypeList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = dicTypeList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)dicTypeList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.insert((Object)dicTypeList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

