/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.persistence.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.persistence.dao.DicSingleMapper;
import com.jxdinfo.hussar.common.persistence.model.DicSingle;
import com.jxdinfo.hussar.common.persistence.model.DicType;
import com.jxdinfo.hussar.common.persistence.service.IDicSingleService;
import com.jxdinfo.hussar.common.persistence.service.IDicTypeService;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DicSingleServiceImpl
extends ServiceImpl<DicSingleMapper, DicSingle>
implements IDicSingleService {
    @Autowired
    private IDicTypeService dicTypeService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private DicSingleMapper dicSingleMapper;

    @Override
    public void evictTypeCacheBySingleId(String id) {
        DicSingle dic = (DicSingle)((Object)this.selectById((Serializable)((Object)id)));
        DicType type = (DicType)((Object)this.dicTypeService.selectById((Serializable)((Object)dic.getTypeId())));
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:" + type.getTypeName());
        }
    }

    @Override
    public List<Map<String, Object>> getDicListByType(String typeId) {
        return this.dicSingleMapper.getDicListByType(typeId);
    }

    @Override
    public List<Map<String, Object>> getCertainDictOptions(String typeId, String[] optionValues) {
        return this.dicSingleMapper.getCertainDictOptions(typeId, optionValues);
    }

    @Override
    public List<Map<String, Object>> getDictOptionsWithoutNotShows(String typeId, String[] notShows) {
        return this.dicSingleMapper.getDictOptionsWithoutNotShows(typeId, notShows);
    }

    @Override
    public String getDictLabel(String typeId, String value) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setValue(value);
        if (ToolUtil.isNotEmpty((Object)this.dicSingleMapper.selectOne((Object)t))) {
            return ((DicSingle)((Object)this.dicSingleMapper.selectOne((Object)t))).getLabel();
        }
        return "";
    }

    @Override
    public String getDictValue(String typeId, String label) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setLabel(label);
        if (ToolUtil.isNotEmpty((Object)this.dicSingleMapper.selectOne((Object)t))) {
            return ((DicSingle)((Object)this.dicSingleMapper.selectOne((Object)t))).getValue();
        }
        return "";
    }
}

