/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.persistence.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.jxdinfo.hussar.common.persistence.model.DicSingle;
import com.jxdinfo.hussar.common.persistence.model.DicType;
import com.jxdinfo.hussar.common.persistence.service.IDicRefService;
import com.jxdinfo.hussar.common.persistence.service.IDicSingleService;
import com.jxdinfo.hussar.common.persistence.service.IDicTypeService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DicRefServiceImpl
implements IDicRefService {
    @Autowired
    private IDicSingleService dicSingleService;
    @Autowired
    private IDicTypeService dicTypeService;

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':list'")
    public List<DicSingle> getDictByType(String typeName) {
        List<DicSingle> result = new ArrayList<DicSingle>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            Wrapper wp = new EntityWrapper().eq("type_id", (Object)type.getId());
            result = this.dicSingleService.selectList(wp);
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':map'")
    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getValue(), dicSingle.getLabel());
        }
        return linkedHashMap;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':allShow'")
    public List<Map<String, Object>> getDicListByType(String typeName) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDicListByType(type.getId());
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':onlyShow'")
    public List<Map<String, Object>> getCertainDictOptions(String typeName, String[] optionValues) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getCertainDictOptions(type.getId(), optionValues);
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':notShow'")
    public List<Map<String, Object>> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDictOptionsWithoutNotShows(type.getId(), notShows);
        }
        return result;
    }

    @Override
    public String getDictLabel(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabel(type.getId(), value);
        }
        return result;
    }

    @Override
    public String getDictValue(String typeName, String label) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDictValue(type.getId(), label);
        }
        return result;
    }

    @Override
    public String getDictOptionsInJson(String typeName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getLabel(), dicSingle.getValue());
        }
        return JSON.toJSONString(linkedHashMap);
    }

    private DicType getTypeInfo(String typeName) {
        return (DicType)((Object)this.dicTypeService.selectOne(new EntityWrapper().eq("type_name", (Object)typeName)));
    }
}

