/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.xss;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private String xssLevel;
    private static final Pattern XSSPATTERN = Pattern.compile(".*([\\\\s%09]*(j|&\\#[0]{0,4}106|&\\#x[0]{0,4}6a)[\\\\s%09]*(a|&\\#[0]{0,4}97|&\\#x[0]{0,4}61)[\\\\s%09]*(v|&\\#[0]{0,4}118|&\\#x[0]{0,4}76)[\\\\s%09]*(a|&\\#[0]{0,4}97|&\\#x[0]{0,4}61)[\\\\s%09]*(s|&\\#[0]{0,4}115|&\\#x[0]{0,4}73)[\\\\s%09]*(c|&\\#[0]{0,4}99|&\\#x[0]{0,4}63)[\\\\s%09]*(r|&\\#[0]{0,4}114|&\\#x[0]{0,4}72)[\\\\s%09]*(i|&\\#[0]{0,4}105|&\\#x[0]{0,4}69)[\\\\s%09]*(p|&\\#[0]{0,4}112|&\\#x[0]{0,4}70)[\\\\s%09]*(t|&\\#[0]{0,4}116|&\\#x[0]{0,4}74)[\\\\s%09]*(\\:|%3A|&\\#[0]{0,4}58|&\\#x[0]{0,4}3a)*[\\\\s%09]*|[\\\\s%09]*(a|&\\#[0]{0,4}97|&\\#x[0]{0,4}61)[\\\\s%09]*(l|&\\#[0]{0,4}108|&\\#x[0]{0,4}6c)[\\\\s%09]*(e|&\\#[0]{0,4}101|&\\#x[0]{0,4}65)[\\\\s%09]*(r|&\\#[0]{0,4}114|&\\#x[0]{0,4}72)[\\\\s%09]*(t|&\\#[0]{0,4}116|&\\#x[0]{0,4}74)|(%27|\\\\'|&\\#[0]{0,4}39)|/(<|%3c|&lt|&\\#[0]{0,4}60)|--|[\\\\s+]and[\\\\s+]|/[\\\\*].*[\\\\*]/and[\\\\s+]|/[\\\\*].*[\\\\*]/and/[\\\\*].*[\\\\*]/|[\\\\s+]and/[\\\\*].*[\\\\*]/(<|%3c|&lt|&\\#[0]{0,4}60)|[\\\\s+]or[\\\\s+]|/[\\\\*].*[\\\\*]/or[\\\\s+]|/[\\\\*].*[\\\\*]/or/[\\\\*].*[\\\\*]/|[\\\\s+]or/[\\\\*].*[\\\\*]/|[\\:%3A](<|%3c|&lt|&\\#[0]{0,4}60)[^\\:%3A]|[^\\:%3A](<|%3c|&lt|&\\#[0]{0,4}60)[\\:%3A]|[\\:%3A](>|%3e|&gt|&\\#[0]{0,4}62)[^\\:%3A]|[^\\:%3A](>|%3e|&gt|&\\#[0]{0,4}62)[\\:%3A]|^(<|%3c|&lt|&\\#[0]{0,4}60).*|^(>|%3e|&gt|&\\#[0]{0,4}62).*|(<|%3c|&lt|&\\#[0]{0,4}60)$|(>|%3e|&gt|&\\#[0]{0,4}62)$|[^\\:%3A](>|%3e|&gt|&\\#[0]{0,4}62)[^\\:%3A]|[^\\:%3A](<|%3c|&lt|&\\#[0]{0,4}60)[^\\:%3A]|(\"|%22|&#[0]{0,4}34)).*");
    private static final Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
    private static final Pattern srcScriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
    private static final Pattern srcScriptPattern2 = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
    private static final Pattern singleScriptPattern = Pattern.compile("</script>", 2);
    private static final Pattern singleScriptPattern2 = Pattern.compile("<script(.*?)>", 42);
    private static final Pattern evalScriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
    private static final Pattern xpressionScriptPattern = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
    private static final Pattern javascriptScriptPattern = Pattern.compile("javascript:", 2);
    private static final Pattern vbsScriptPattern = Pattern.compile("vbscript:", 2);
    private static final Pattern onloadScriptPattern = Pattern.compile("onload(.*?)=", 42);

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String xssLevel) {
        super(servletRequest);
        this.xssLevel = xssLevel;
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(values[i], this.xssLevel);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value, this.xssLevel);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value, this.xssLevel);
    }

    private String cleanXSS(String value, String xssLevel) {
        if (value != null) {
            value = "A".equals(xssLevel) ? this.levelA(value) : ("C".equals(xssLevel) ? this.levelC(value) : this.levelB(value));
        }
        return value;
    }

    private String levelA(String value) {
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
        value = value.replaceAll("'", "& #39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }

    private String levelB(String value) {
        String rtnValue = value;
        rtnValue = scriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = srcScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = srcScriptPattern2.matcher(rtnValue).replaceAll("");
        rtnValue = singleScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = singleScriptPattern2.matcher(rtnValue).replaceAll("");
        rtnValue = evalScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = xpressionScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = javascriptScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = vbsScriptPattern.matcher(rtnValue).replaceAll("");
        rtnValue = onloadScriptPattern.matcher(rtnValue).replaceAll("");
        return rtnValue;
    }

    private String levelC(String value) {
        value = XSSPATTERN.matcher(value).replaceAll("");
        return value;
    }
}

