/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.xss;

import com.jxdinfo.hussar.common.firewall.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class XssFilter
implements Filter {
    FilterConfig filterConfig = null;
    private List<String> urlExclusion = null;
    private String xssLevel;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String servletPath = httpServletRequest.getServletPath();
        if (this.urlExclusion != null && this.urlExclusion.contains(servletPath)) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request, this.xssLevel), response);
        }
    }

    public List<String> getUrlExclusion() {
        return this.urlExclusion;
    }

    public void setUrlExclusion(List<String> urlExclusion) {
        this.urlExclusion = urlExclusion;
    }

    public String getXssLevel() {
        return this.xssLevel;
    }

    public void setXssLevel(String xssLevel) {
        this.xssLevel = xssLevel;
    }
}

