/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.export;

import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.export.bean.ExcelEntity;
import com.jxdinfo.hussar.common.export.bean.ExcelTitle;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportExcel<T> {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void exportExcel(OutputStream outputStream, ExcelEntity excelEntity) {
        try {
            this.exportExcelMap(outputStream, excelEntity.getQuerys(), excelEntity.getTitles(), excelEntity.getBlankTop(), excelEntity.getBlankLeft());
        }
        catch (IOException exp) {
            this.log.error("excel\u6587\u4ef6\u5bfc\u51fa\u62a5\u9519\uff1a" + exp.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EXPORTEXCEL_ERROR);
        }
    }

    public void exportExcel(String fileName, List<T> querys, List<ExcelTitle> titles) throws IOException {
        for (ExcelTitle excelTitle : titles) {
            String string = excelTitle.getTitle_id();
        }
    }

    private void exportExcelMap(OutputStream outputStream, List<Map<String, Object>> querys, List<ExcelTitle> titles, boolean blankTop, boolean blankLeft) throws IOException {
        int rowIndex = 0;
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        Sheet sheet = xssfWorkbook.createSheet();
        if (blankTop) {
            sheet.createRow(rowIndex++);
        }
        int leftInde = 0;
        if (blankLeft) {
            ++leftInde;
        }
        Row headRow = sheet.createRow(rowIndex++);
        for (int i = 0; i < titles.size(); ++i) {
            ExcelTitle excelTitle = titles.get(i);
            Cell cell = headRow.createCell(leftInde + i);
            cell.setCellValue(excelTitle.getTitle_text());
            CellStyle headCellStyle = xssfWorkbook.createCellStyle();
            headCellStyle.setAlignment(HorizontalAlignment.CENTER);
            headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            Font font = xssfWorkbook.createFont();
            font.setBold(true);
            headCellStyle.setFont(font);
            headCellStyle.setBorderLeft(BorderStyle.THIN);
            headCellStyle.setBorderTop(BorderStyle.THIN);
            headCellStyle.setBorderRight(BorderStyle.THIN);
            headCellStyle.setBorderBottom(BorderStyle.THIN);
            cell.setCellStyle(headCellStyle);
        }
        CellStyle bodyCellStyle = xssfWorkbook.createCellStyle();
        bodyCellStyle.setAlignment(HorizontalAlignment.CENTER);
        bodyCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        bodyCellStyle.setBorderLeft(BorderStyle.THIN);
        bodyCellStyle.setBorderTop(BorderStyle.THIN);
        bodyCellStyle.setBorderRight(BorderStyle.THIN);
        bodyCellStyle.setBorderBottom(BorderStyle.THIN);
        for (int i = 0; i < querys.size(); ++i) {
            Map<String, Object> map = querys.get(i);
            Row rowBody = sheet.createRow(rowIndex + i);
            for (int j = 0; j < titles.size(); ++j) {
                ExcelTitle excelTitle = titles.get(j);
                String textId = excelTitle.getTitle_id();
                Cell bodyCell = rowBody.createCell(j + leftInde);
                bodyCell.setCellStyle(bodyCellStyle);
                Object obj = map.get(textId);
                if (obj instanceof String) {
                    bodyCell.setCellValue((String)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    bodyCell.setCellValue(((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof Date) {
                    bodyCell.setCellValue((Date)obj);
                    continue;
                }
                if (obj instanceof Calendar) {
                    bodyCell.setCellValue((Calendar)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    bodyCell.setCellValue(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Integer) {
                    bodyCell.setCellValue((double)((Integer)obj).intValue());
                    continue;
                }
                bodyCell.setCellValue((String)obj);
            }
        }
        xssfWorkbook.write(outputStream);
        xssfWorkbook.close();
    }
}

