/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.dicutil;

import com.jxdinfo.hussar.common.persistence.model.DicSingle;
import com.jxdinfo.hussar.common.persistence.service.IDicRefService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryUtil {
    @Autowired
    private IDicRefService sysDicRefService;

    public List<DicSingle> getDictByType(String typeName) {
        return this.sysDicRefService.getDictByType(typeName);
    }

    public List<Map<String, Object>> getDictListByType(String typeName) {
        return this.sysDicRefService.getDicListByType(typeName);
    }

    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        return this.sysDicRefService.getDictMapByType(typeName);
    }

    public List<Map<String, Object>> getCertainDictOptions(String typeName, String[] optionValues) {
        return this.sysDicRefService.getCertainDictOptions(typeName, optionValues);
    }

    public List<Map<String, Object>> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        return this.sysDicRefService.getDictOptionsWithoutNotShows(typeName, notShows);
    }

    public String getDictLabel(String typeName, String value) {
        return this.sysDicRefService.getDictLabel(typeName, value);
    }

    public String getDictValue(String typeName, String label) {
        return this.sysDicRefService.getDictValue(typeName, label);
    }

    public JSONArray getDictListJsonObjectByType(String typeName) {
        return JSONArray.fromObject(this.sysDicRefService.getDicListByType(typeName));
    }

    public JSONObject getDictMapJsonObjectByType(String typeName) {
        return JSONObject.fromObject(this.sysDicRefService.getDictMapByType(typeName));
    }

    public String getDictOptionsInJson(String typeName) {
        return this.sysDicRefService.getDictOptionsInJson(typeName);
    }
}

