/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.constant.factory;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.jxdinfo.hussar.common.constant.factory.IConstantFactory;
import com.jxdinfo.hussar.common.constant.state.ManagerStatus;
import com.jxdinfo.hussar.common.constant.state.MenuStatus;
import com.jxdinfo.hussar.common.persistence.dao.DictMapper;
import com.jxdinfo.hussar.common.persistence.dao.MenuMapper;
import com.jxdinfo.hussar.common.persistence.dao.NoticeMapper;
import com.jxdinfo.hussar.common.persistence.dao.ResourcesMapper;
import com.jxdinfo.hussar.common.persistence.dao.RoleMapper;
import com.jxdinfo.hussar.common.persistence.dao.RolesMapper;
import com.jxdinfo.hussar.common.persistence.dao.StruMapper;
import com.jxdinfo.hussar.common.persistence.dao.UserMapper;
import com.jxdinfo.hussar.common.persistence.dao.UserRoleMapper;
import com.jxdinfo.hussar.common.persistence.model.Dict;
import com.jxdinfo.hussar.common.persistence.model.Menu;
import com.jxdinfo.hussar.common.persistence.model.Notice;
import com.jxdinfo.hussar.common.persistence.model.Role;
import com.jxdinfo.hussar.common.persistence.model.SysRoles;
import com.jxdinfo.hussar.common.persistence.model.User;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.Convert;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"springContextHolder"})
public class ConstantFactory
implements IConstantFactory {
    private RoleMapper roleMapper = (RoleMapper)SpringContextHolder.getBean(RoleMapper.class);
    private StruMapper struMapper = (StruMapper)SpringContextHolder.getBean(StruMapper.class);
    private DictMapper dictMapper = (DictMapper)SpringContextHolder.getBean(DictMapper.class);
    private UserMapper userMapper = (UserMapper)SpringContextHolder.getBean(UserMapper.class);
    private MenuMapper menuMapper = (MenuMapper)SpringContextHolder.getBean(MenuMapper.class);
    private NoticeMapper noticeMapper = (NoticeMapper)SpringContextHolder.getBean(NoticeMapper.class);
    private UserRoleMapper userRoleMapper = (UserRoleMapper)SpringContextHolder.getBean(UserRoleMapper.class);
    private RolesMapper RolesMapper = (RolesMapper)SpringContextHolder.getBean(RolesMapper.class);
    private ResourcesMapper resourcesMapper = (ResourcesMapper)SpringContextHolder.getBean(ResourcesMapper.class);

    public static IConstantFactory me() {
        return (IConstantFactory)SpringContextHolder.getBean((String)"constantFactory");
    }

    @Override
    @Cacheable(value={"authorization_info"}, key="'shiro_authInfo:'+#shiroUser.id")
    public Map<String, List<String>> getAuthInfo(ShiroUser shiroUser) {
        List<String> permissionList = this.resourcesMapper.getResourceByUserId(shiroUser.getId());
        List<String> repeatAuthenticateList = this.resourcesMapper.getIsRepeatAuthenticateId(shiroUser.getId());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("userPermission", permissionList);
        map.put("repeatAuthenticate", repeatAuthenticateList);
        return map;
    }

    @Override
    public List<String> getRolesIdByUserId(String userId) {
        List<String> rolesList = this.userRoleMapper.getRolesByUserId(userId);
        return rolesList;
    }

    @Override
    public String getRoleNameByRoleId(String roleId) {
        SysRoles sysRoles = (SysRoles)((Object)this.RolesMapper.selectById((Serializable)((Object)roleId)));
        if (ToolUtil.isNotEmpty((Object)((Object)sysRoles)) && ToolUtil.isNotEmpty((Object)sysRoles.getRoleName())) {
            return sysRoles.getRoleName();
        }
        return null;
    }

    @Override
    public String getUserNameById(Integer userId) {
        User user = (User)((Object)this.userMapper.selectById(userId));
        if (user != null) {
            return user.getName();
        }
        return "--";
    }

    @Override
    public String getUserAccountById(Integer userId) {
        User user = (User)((Object)this.userMapper.selectById(userId));
        if (user != null) {
            return user.getAccount();
        }
        return "--";
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'roles_name_'+#roleIds")
    public String getRoleName(String roleIds) {
        Integer[] roles = Convert.toIntArray((String)roleIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = roles;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int role = integerArray[i];
            Role roleObj = (Role)((Object)this.roleMapper.selectById(Integer.valueOf(role)));
            if (!ToolUtil.isNotEmpty((Object)((Object)roleObj)) || !ToolUtil.isNotEmpty((Object)roleObj.getName())) continue;
            sb.append(roleObj.getName()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'single_role_name_'+#roleId")
    public String getSingleRoleName(Integer roleId) {
        if (0 == roleId) {
            return "--";
        }
        Role roleObj = (Role)((Object)this.roleMapper.selectById(roleId));
        if (ToolUtil.isNotEmpty((Object)((Object)roleObj)) && ToolUtil.isNotEmpty((Object)roleObj.getName())) {
            return roleObj.getName();
        }
        return "";
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'single_role_tip_'+#roleId")
    public String getSingleRoleTip(Integer roleId) {
        if (0 == roleId) {
            return "--";
        }
        Role roleObj = (Role)((Object)this.roleMapper.selectById(roleId));
        if (ToolUtil.isNotEmpty((Object)((Object)roleObj)) && ToolUtil.isNotEmpty((Object)roleObj.getName())) {
            return roleObj.getTips();
        }
        return "";
    }

    @Override
    public String getDeptName(String deptId) {
        Map<String, Object> dept = this.struMapper.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty(dept) && ToolUtil.isNotEmpty((Object)dept.get("ORGANNAME"))) {
            return (String)dept.get("ORGANNAME");
        }
        return "";
    }

    @Override
    public String getMenuNames(String menuIds) {
        Integer[] menus = Convert.toIntArray((String)menuIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = menus;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int menu = integerArray[i];
            Menu menuObj = (Menu)((Object)this.menuMapper.selectById(Integer.valueOf(menu)));
            if (!ToolUtil.isNotEmpty((Object)((Object)menuObj)) || !ToolUtil.isNotEmpty((Object)menuObj.getName())) continue;
            sb.append(menuObj.getName()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    @Override
    public String getMenuName(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            return "";
        }
        Menu menu = (Menu)((Object)this.menuMapper.selectById(menuId));
        if (menu == null) {
            return "";
        }
        return menu.getName();
    }

    @Override
    public String getMenuNameByCode(String code) {
        if (ToolUtil.isEmpty((Object)code)) {
            return "";
        }
        Menu param = new Menu();
        param.setCode(code);
        Menu menu = (Menu)((Object)this.menuMapper.selectOne((Object)param));
        if (menu == null) {
            return "";
        }
        return menu.getName();
    }

    @Override
    public String getDictName(Integer dictId) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            return "";
        }
        Dict dict = (Dict)((Object)this.dictMapper.selectById(dictId));
        if (dict == null) {
            return "";
        }
        return dict.getName();
    }

    @Override
    public String getNoticeTitle(Integer dictId) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            return "";
        }
        Notice notice = (Notice)((Object)this.noticeMapper.selectById(dictId));
        if (notice == null) {
            return "";
        }
        return notice.getTitle();
    }

    @Override
    public String getDictsByName(String name, Integer val) {
        Dict temp = new Dict();
        temp.setName(name);
        Dict dict = (Dict)((Object)this.dictMapper.selectOne((Object)temp));
        if (dict == null) {
            return "";
        }
        EntityWrapper wrapper = new EntityWrapper();
        wrapper = wrapper.eq("pid", (Object)dict.getId());
        List dicts = this.dictMapper.selectList((Wrapper)wrapper);
        for (Dict item : dicts) {
            if (item.getNum() == null || !item.getNum().equals(val)) continue;
            return item.getName();
        }
        return "";
    }

    @Override
    public String getSexName(Integer sex) {
        return this.getDictsByName("\u6027\u522b", sex);
    }

    @Override
    public String getStatusName(Integer status) {
        return ManagerStatus.valueOf(status);
    }

    @Override
    public String getMenuStatusName(Integer status) {
        return MenuStatus.valueOf(status);
    }

    @Override
    public List<Dict> findInDict(Integer id) {
        if (ToolUtil.isEmpty((Object)id)) {
            return null;
        }
        EntityWrapper wrapper = new EntityWrapper();
        List dicts = this.dictMapper.selectList(wrapper.eq("pid", (Object)id));
        if (dicts == null || dicts.size() == 0) {
            return null;
        }
        return dicts;
    }

    @Override
    public String getCacheObject(String para) {
        return LogObjectHolder.me().get().toString();
    }

    @Override
    public List<String> getIsRepeatAuthenticateId(String userId) {
        List<String> list = this.resourcesMapper.getIsRepeatAuthenticateId(userId);
        return list;
    }
}

