/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.enums.MigrateFuncResMenuEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceType;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceTypeExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResTypeExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.ResTypeExpandVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceExpandVo;
import com.jxdinfo.hussar.authorization.publishrecord.model.SysPublishRecord;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysFuncResMenuMigrationPlugin
implements MigrationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SysFuncResMenuMigrationPlugin.class);
    public static final String TYPE = "funcResMenu";
    private static final FuncResMenuMetaData FUNCRESMENUMETADATA = new FuncResMenuMetaData();
    @Resource
    private ISysFunctionsService functionsService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysFunctionResourcesService functionResourcesService;
    @Autowired
    private IHussarBaseResourceTypeService hussarBaseResourceTypeService;
    @Resource
    private IHussarBaseResTypeExpandService hussarBaseResTypeExpandService;
    @Autowired
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Autowired
    private ISysPublishRecordService sysPublishRecordService;

    public MigrationPluginMetadata metadata() {
        return FUNCRESMENUMETADATA;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        List funcDumpDtoList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)parameters.get("funcResMenuInfo")), (TypeReference)new TypeReference<List<FuncDumpDto>>(){});
        List result = new ArrayList();
        if (funcDumpDtoList.isEmpty()) {
            context.setAttribute("total", (Object)0L);
            return MigrationDumpItemVo.success((Long)0L, result);
        }
        Map allData = this.functionsService.getFuncResMenuDumpData(funcDumpDtoList);
        if (HussarUtils.isNotEmpty((Object)allData)) {
            context.setPayloadOfJson("function.json", allData.get("function"));
            context.setPayloadOfJson("functionModule.json", allData.get("functionModule"));
            context.setPayloadOfJson("functionResources.json", allData.get("functionResources"));
            context.setPayloadOfJson("resources.json", allData.get("resources"));
            context.setPayloadOfJson("resourceModule.json", allData.get("resourceModule"));
            context.setPayloadOfJson("menu.json", allData.get("menu"));
            context.setPayloadOfJson("publishRecord.json", allData.get("publishRecord"));
            context.setAttribute("total", allData.get("total"));
            result = this.functionsService.getFuncResMenuDumpTree(allData);
        }
        return MigrationDumpItemVo.success((Long)((Long)allData.get("total")), result);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List functionsList = (List)context.getPayloadAsJson("function.json", (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List resourcesList = (List)context.getPayloadAsJson("resources.json", (TypeReference)new TypeReference<List<ResourceDetailVo>>(){});
        List functionResourcesList = (List)context.getPayloadAsJson("functionResources.json", (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List functionModulesList = (List)context.getPayloadAsJson("functionModule.json", (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        List menuList = (List)context.getPayloadAsJson("menu.json", (TypeReference)new TypeReference<List<SysMenu>>(){});
        List resourceModulesList = (List)context.getPayloadAsJson("resourceModule.json", (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        HashMap<String, List> importData = new HashMap<String, List>();
        importData.put("function", functionsList);
        importData.put("resources", resourcesList);
        importData.put("functionResources", functionResourcesList);
        importData.put("functionModule", functionModulesList);
        importData.put("menu", menuList);
        importData.put("resourceModule", resourceModulesList);
        List result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)functionsList)) {
            result = this.functionsService.getFuncResMenuCheckTree(importData);
        }
        return MigrationPreloadItemVo.success(result);
    }

    @HussarTransactional
    @CacheEvict(value={"menu_info", "resource_info"}, allEntries=true)
    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        List functionsList = (List)context.getPayloadAsJson("function.json", (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List resourcesViewList = (List)context.getPayloadAsJson("resources.json", (TypeReference)new TypeReference<List<ResourceDetailVo>>(){});
        List resourcesList = (List)context.getPayloadAsJson("resources.json", (TypeReference)new TypeReference<List<SysResources>>(){});
        List functionResourcesList = (List)context.getPayloadAsJson("functionResources.json", (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List functionModulesList = (List)context.getPayloadAsJson("functionModule.json", (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        List menuList = (List)context.getPayloadAsJson("menu.json", (TypeReference)new TypeReference<List<SysMenu>>(){});
        List resourceModulesList = (List)context.getPayloadAsJson("resourceModule.json", (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        List importPublishRecordList = (List)context.getPayloadAsJson("publishRecord.json", (TypeReference)new TypeReference<List<SysPublishRecord>>(){});
        Set sourceIdInSystem = this.sysPublishRecordService.list().stream().map(SysPublishRecord::getSourceId).collect(Collectors.toSet());
        ArrayList<SysPublishRecord> sysPublishRecordList = new ArrayList<SysPublishRecord>();
        for (SysPublishRecord publishRecord : importPublishRecordList) {
            if (sourceIdInSystem.contains(publishRecord.getSourceId())) continue;
            sysPublishRecordList.add(publishRecord);
        }
        HashMap<String, List> importData = new HashMap<String, List>();
        importData.put("function", functionsList);
        importData.put("resources", resourcesViewList);
        importData.put("functionResources", functionResourcesList);
        importData.put("functionModule", functionModulesList);
        importData.put("menu", menuList);
        importData.put("resourceModule", resourceModulesList);
        boolean tenantFlag = false;
        if (this.tenantProperties.isEnabled() && !((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
            tenantFlag = true;
        }
        List result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)functionsList)) {
            result = this.functionsService.getFuncResMenuCheckTree(importData);
            this.functionsService.saveOrUpdateBatch((Collection)functionsList);
            this.saveAdminFunctionList(functionsList, tenantFlag);
        }
        this.sysFunctionModulesService.saveOrUpdateBatch((Collection)functionModulesList);
        this.sysMenuManageService.saveOrUpdateBatch((Collection)menuList);
        this.sysResourcesService.saveOrUpdateBatch((Collection)resourcesList);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            this.saveAdminResourceList(resourcesList, tenantFlag);
        }
        this.sysResourceMosulesService.saveOrUpdateBatch((Collection)resourceModulesList);
        if (HussarUtils.isNotEmpty((Object)functionResourcesList)) {
            this.functionResourcesService.deleteListByDoubleIds(functionResourcesList);
            this.functionResourcesService.saveBatch((Collection)functionResourcesList);
        }
        this.sysPublishRecordService.saveOrUpdateBatch(sysPublishRecordList);
        if (HussarUtils.isNotEmpty((Object)resourcesViewList)) {
            this.saveResourceTypeList(resourcesViewList);
        }
        int totalInt = (Integer)context.getAttribute("total");
        return MigrationLoadItemVo.success((Long)Long.valueOf(totalInt), result);
    }

    private void saveAdminFunctionList(List<SysFunctions> functionsList, boolean tenantFlag) {
        ArrayList<SysRoleFunctions> roleFunctionList = new ArrayList<SysRoleFunctions>();
        ArrayList<Long> functionIds = new ArrayList<Long>();
        for (SysFunctions function : functionsList) {
            Long functionId = function.getId();
            functionIds.add(functionId);
            SysRoleFunctions roleFunction = new SysRoleFunctions();
            roleFunction.setFunctionId(functionId);
            if (tenantFlag) {
                roleFunction.setRoleId(TenantConstant.ADMIN_ROLE);
            } else {
                roleFunction.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
            }
            roleFunctionList.add(roleFunction);
        }
        if (HussarUtils.isNotEmpty(roleFunctionList)) {
            LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleFunctions::getFunctionId, functionIds);
            if (tenantFlag) {
                this.sysRoleFunctionsService.remove((Wrapper)wrapper.eq(SysRoleFunctions::getRoleId, (Object)TenantConstant.ADMIN_ROLE));
            } else {
                this.sysRoleFunctionsService.remove((Wrapper)wrapper.eq(SysRoleFunctions::getRoleId, (Object)SysUserAndRole.SUPERADMIN_ROLE.getValue()));
            }
            this.sysRoleFunctionsService.saveBatch(roleFunctionList);
        }
    }

    private void saveAdminResourceList(List<SysResources> resourcesList, boolean tenantFlag) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        ArrayList<Long> resourceIds = new ArrayList<Long>();
        for (SysResources resource : resourcesList) {
            Long resourceId = resource.getId();
            resourceIds.add(resourceId);
            SysRoleResource roleResource = new SysRoleResource();
            roleResource.setResourceId(resourceId);
            roleResource.setRelationSource("1");
            if (tenantFlag) {
                roleResource.setRoleId(TenantConstant.ADMIN_ROLE);
            } else {
                roleResource.setRoleId(SysUserAndRole.SUPERADMIN_ROLE.getValue());
            }
            roleResourceList.add(roleResource);
        }
        if (HussarUtils.isNotEmpty(roleResourceList)) {
            LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getResourceId, resourceIds);
            if (tenantFlag) {
                this.sysRoleResourceService.remove((Wrapper)wrapper.eq(SysRoleResource::getRoleId, (Object)TenantConstant.ADMIN_ROLE));
            } else {
                this.sysRoleResourceService.remove((Wrapper)wrapper.eq(SysRoleResource::getRoleId, (Object)SysUserAndRole.SUPERADMIN_ROLE.getValue()));
            }
            this.sysRoleResourceService.saveBatch(roleResourceList);
        }
    }

    private void saveResourceTypeList(List<ResourceDetailVo> resourcesViewList) {
        for (ResourceDetailVo resourceDetailVo : resourcesViewList) {
            if (!HussarUtils.isEmpty((Object)MigrateFuncResMenuEnum.of((String)resourceDetailVo.getResTypeId()))) continue;
            if (resourceDetailVo.getResourceExpands() != null) {
                List resourceExpands = resourceDetailVo.getResourceExpands();
                for (ResourceExpandVo resourceExpand : resourceExpands) {
                    SysResourceExpand sysResourceExpand = new SysResourceExpand();
                    BeanUtils.copyProperties((Object)resourceExpand, (Object)sysResourceExpand);
                    sysResourceExpand.setId(resourceExpand.getExpandId());
                    LambdaQueryWrapper sysResourceExpandLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)sysResourceExpandLambdaQueryWrapper.eq(SysResourceExpand::getResourceId, (Object)sysResourceExpand.getResourceId())).eq(SysResourceExpand::getResourceTypeExpandCode, (Object)sysResourceExpand.getResourceTypeExpandCode());
                    this.hussarBaseResourceExpandService.saveOrUpdate((Object)sysResourceExpand, (Wrapper)sysResourceExpandLambdaQueryWrapper);
                }
            }
            SysResourceType resourceType = new SysResourceType();
            if (HussarUtils.isNotEmpty((Object)resourceDetailVo.getResourceTypeExpands())) {
                String resourceTypeId = ((ResTypeExpandVo)resourceDetailVo.getResourceTypeExpands().get(0)).getResourceTypeId();
                resourceType.setId(Long.valueOf(resourceTypeId));
            }
            resourceType.setResourceTypeName(resourceDetailVo.getSysResource().getResourceTypeName());
            resourceType.setResourceTypeCode(resourceDetailVo.getResTypeId());
            resourceType.setTypeStatus(Integer.valueOf(1));
            resourceType.setIsSys(Integer.valueOf(0));
            LambdaUpdateWrapper sysResourceTypeLambdaUpdateWrapper = new LambdaUpdateWrapper();
            sysResourceTypeLambdaUpdateWrapper.eq(SysResourceType::getResourceTypeCode, (Object)resourceType.getResourceTypeCode());
            this.hussarBaseResourceTypeService.saveOrUpdate((Object)resourceType, (Wrapper)sysResourceTypeLambdaUpdateWrapper);
            List resourceTypeExpands = resourceDetailVo.getResourceTypeExpands();
            if (resourceTypeExpands == null) continue;
            for (ResTypeExpandVo resourceTypeExpand : resourceTypeExpands) {
                SysResourceTypeExpand sysResourceTypeExpandSave = new SysResourceTypeExpand();
                BeanUtils.copyProperties((Object)resourceTypeExpand, (Object)sysResourceTypeExpandSave);
                sysResourceTypeExpandSave.setResourceTypeId(Long.valueOf(resourceTypeExpand.getResourceTypeId()));
                if (resourceTypeExpand.getExpandOptions() != null) {
                    String options = JSON.toJSONString((Object)resourceTypeExpand.getExpandOptions());
                    sysResourceTypeExpandSave.setExpandOptions(options);
                }
                List collect = resourceDetailVo.getResourceExpands().stream().filter(r -> r.getResourceTypeExpandCode().equals(sysResourceTypeExpandSave.getExpandCode())).collect(Collectors.toList());
                sysResourceTypeExpandSave.setId(((ResourceExpandVo)collect.get(0)).getResourceTypeExpandId());
                LambdaUpdateWrapper sysResourceTypeExpandLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)sysResourceTypeExpandLambdaUpdateWrapper.eq(SysResourceTypeExpand::getResourceTypeId, (Object)sysResourceTypeExpandSave.getResourceTypeId())).eq(SysResourceTypeExpand::getExpandCode, (Object)sysResourceTypeExpandSave.getExpandCode());
                this.hussarBaseResTypeExpandService.saveOrUpdate((Object)sysResourceTypeExpandSave, (Wrapper)sysResourceTypeExpandLambdaUpdateWrapper);
            }
        }
    }

    private static final class FuncResMenuMetaData
    implements MigrationPluginMetadata {
        private FuncResMenuMetaData() {
        }

        public String getServiceType() {
            return SysFuncResMenuMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return super.getVersion();
        }

        public int getDumpPrecedence() {
            return super.getDumpPrecedence();
        }
    }
}

