/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.authorization.permit.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.authorization.permit.vo.DataLogicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.sysAppVisitDataLogicServiceImpl")
public class SysAppVisitDataLogicServiceImpl
extends HussarServiceImpl<SysAppVisitDataLogicMapper, SysAppVisitDataLogic>
implements ISysAppVisitDataLogicService {
    @Resource
    private ISysAppVisitDataLogicFilterService sysAppVisitDataLogicFilterService;

    public SysAppVisitDataLogic getDataLogic(Long appId, Long formId, Long roleId) {
        return (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)appId), SysAppVisitDataLogic::getAppId, (Object)appId)).eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitDataLogic::getFormId, (Object)formId)).eq(HussarUtils.isNotEmpty((Object)roleId), SysAppVisitDataLogic::getRoleId, (Object)roleId));
    }

    public List<SysAppVisitDataLogic> listDataLogic(Long appId, Long formId, Long roleId) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)appId), SysAppVisitDataLogic::getAppId, (Object)appId)).eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitDataLogic::getFormId, (Object)formId)).eq(HussarUtils.isNotEmpty((Object)roleId), SysAppVisitDataLogic::getRoleId, (Object)roleId));
    }

    public List<SysAppVisitDataLogic> listDataLogicByRoles(Long appId, Long formId, List<Long> roleIds) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)appId), SysAppVisitDataLogic::getAppId, (Object)appId)).eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitDataLogic::getFormId, (Object)formId)).in(roleIds != null, SysAppVisitDataLogic::getRoleId, roleIds));
    }

    public List<DataLogicVo> listDataLogicAuthority(Long appId, Long formId, Long roleId) {
        List<Object> result = new ArrayList<DataLogicVo>();
        List<SysAppVisitDataLogic> dataLogicList = this.listDataLogic(appId, formId, roleId);
        if (HussarUtils.isNotEmpty(dataLogicList)) {
            List logicIds = dataLogicList.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            List dataLogicFilterListByLogicIds = this.sysAppVisitDataLogicFilterService.dataLogicFilterListByLogicIds(logicIds);
            Map<Long, List<SysAppVisitDataLogicFilter>> mapDataLogicFilter = dataLogicFilterListByLogicIds.stream().collect(Collectors.groupingBy(SysAppVisitDataLogicFilter::getRoleDataLogicId));
            result = dataLogicList.stream().map(dataLogic -> {
                DataLogicVo dataLogicVo = new DataLogicVo();
                BeanUtil.copy((Object)dataLogic, (Object)dataLogicVo);
                List dataLogicFilters = (List)mapDataLogicFilter.get(dataLogic.getId());
                List<Object> dataLogicFilterVos = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)dataLogicFilters)) {
                    dataLogicFilterVos = dataLogicFilters.stream().map(item -> {
                        DataLogicFilterVo dataLogicFilterVo = new DataLogicFilterVo();
                        dataLogicFilterVo.setFieldId(item.getFieldId());
                        dataLogicFilterVo.setFieldName(item.getFieldName());
                        dataLogicFilterVo.setFilterCode(item.getFilterConditionCode());
                        dataLogicFilterVo.setFilterName(item.getFilterConditionName());
                        dataLogicFilterVo.setFilterValue(item.getFilterValue());
                        return dataLogicFilterVo;
                    }).collect(Collectors.toList());
                }
                dataLogicVo.setFilters(dataLogicFilterVos);
                return dataLogicVo;
            }).collect(Collectors.toList());
        }
        return result;
    }

    @HussarTransactional
    public Boolean deleteDataLogicByFormId(Long appId, Long formId, List<Long> roleIds) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{appId, formId, roleIds})) {
            return Boolean.TRUE;
        }
        List<SysAppVisitDataLogic> dataLogics = this.listDataLogicByRoles(appId, formId, roleIds);
        if (HussarUtils.isNotEmpty(dataLogics)) {
            List logicIds = dataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.removeByIds(logicIds);
            this.sysAppVisitDataLogicFilterService.deleteDataLogicFilterByLogicIds(logicIds);
        }
        return Boolean.TRUE;
    }

    @HussarTransactional
    public Boolean deleteDataLogicByRoleIdFormIds(Long roleId, List<Long> formIds) {
        List dataLogics = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getRoleId, (Object)roleId)).in(SysAppVisitDataLogic::getFormId, formIds));
        if (HussarUtils.isNotEmpty((Object)dataLogics)) {
            List logicIds = dataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.removeByIds(logicIds);
            this.sysAppVisitDataLogicFilterService.deleteDataLogicFilterByLogicIds(logicIds);
        }
        return Boolean.TRUE;
    }
}

