/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDtoByAppRole;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionModuleAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionResourceAdapterService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalFunctionAdapterServiceImpl
extends HussarBaseServiceImpl<SysFunctionsMapper, SysFunctions>
implements ILocalFunctionAdapterService {
    private static Logger logger = LoggerFactory.getLogger(LocalFunctionAdapterServiceImpl.class);
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ILocalFunctionResourceAdapterService localFunctionResourceAdapterService;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private ILocalFunctionModuleAdapterService localFunctionModuleAdapterService;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;
    @Resource
    private SysMenuMapper sysMenuMapper;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    public static final String CONTAIN_SYS = "containSys";
    public static final String SHOW_FLAG = "showFlag";
    public static final String APP_ID = "appId";
    public static final String BIZ_APP_ID = "bizAppId";

    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.sysFunctionsMapper.getMaxOrderByParentId(moduleId);
    }

    public List<SysFunctionResources> listByFuncIdAndResId(Long functionId, Long resourceId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)functionId)) {
            lambdaQueryWrapper.eq(SysFunctionResources::getFunctionId, (Object)functionId);
        }
        if (HussarUtils.isNotEmpty((Object)resourceId)) {
            lambdaQueryWrapper.eq(SysFunctionResources::getResourceId, (Object)resourceId);
        }
        return this.localFunctionResourceAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        return this.sysFunctionModulesMapper.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag, Long appId, String showFlag, Long bizAppId) {
        SysApplication application;
        SecurityUser shiroUser;
        List sysUserRoleIds;
        Long roleId;
        String tenantType;
        List<JSTreeModel> res;
        List<JSTreeModel> moduleList;
        boolean flag;
        boolean bl = flag = !HussarUtils.isEmpty((Object)functionFlag) && Boolean.parseBoolean(functionFlag);
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        String containSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            containSys = "0";
        }
        boolean open = this.secureAssesmentProperties.isOpen();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(APP_ID, appId);
        queryParams.put(BIZ_APP_ID, bizAppId);
        if ("1".equals(showFlag)) {
            queryParams.put(SHOW_FLAG, showFlag);
        } else {
            queryParams.put(SHOW_FLAG, null);
        }
        if (open) {
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeWithSource(queryParams);
        }
        TranslateUtil.translate(moduleList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        List<Object> result = new ArrayList<JSTreeModel>(moduleList);
        if (open) {
            res = this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionDataForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            res = this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionDataForSource(queryParams);
        }
        TranslateUtil.translate(res, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        result.addAll(res);
        if (!flag) {
            result = result.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        if ("onsystem".equals(tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.core.tenant.type")) && HussarUtils.isEmpty((Object)(roleId = (Long)(sysUserRoleIds = (shiroUser = BaseSecurityUtil.getUser()).getRolesList()).stream().filter(l -> SysUserAndRole.TENANT_ADMIN_ROLE.getValue().equals(l) || SysUserAndRole.SUPERADMIN_ROLE.getValue().equals(l)).findAny().orElse(null)))) {
            List currentAppIds = this.sysApplicationService.getCurrentAppIds(shiroUser.getId());
            result = result.stream().filter(jsTreeModel -> currentAppIds.contains(jsTreeModel.getAppId()) || Constants.DEFAULT_SYS_APP_ID.equals(jsTreeModel.getApplicationId()) && HussarUtils.isEmpty((Object)jsTreeModel.getAppId())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        if (HussarUtils.isNotEmpty((Object)appId) && appId != 1L && HussarUtils.isNotEmpty((Object)(application = (SysApplication)this.sysApplicationService.getById((Serializable)appId)))) {
            JSTreeModel appRoot = new JSTreeModel();
            appRoot.setId(application.getId());
            appRoot.setCode(application.getAppCode());
            appRoot.setText(application.getAppName());
            appRoot.setParent(Constants.RES_NODE_ID);
            appRoot.setApplicationId(application.getId());
            appRoot.setIsLeaf("0");
            appRoot.setIsModule("1");
            appRoot.setType("isRoot");
            appRoot.setConstant("0");
            result.add(appRoot);
        }
        List funIds = result.stream().filter(fun -> "1".equals(fun.getIsFun())).map(JSTreeModel::getId).collect(Collectors.toList());
        logger.info("\u89d2\u8272\u5173\u8054\u529f\u80fd--\u529f\u80fd\u6a21\u5757\u6811\u5c55\u793a\u7684\u529f\u80fdID\uff0c\u5171\u8ba1{}\u4e2a : {}", (Object)funIds.size(), funIds);
        result = TreeModelUtils.merge(result);
        return result;
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag, Long appId, String showFlag) {
        return this.getFunModuleMergeTreeForOrg(functionFlag, appId, showFlag, null);
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrgByAppRole(ResTreeDtoByAppRole queryFuncDto) {
        List<JSTreeModel> res;
        List<JSTreeModel> moduleList;
        String functionFlag = queryFuncDto.getFunctionFlag();
        Long applicationId = queryFuncDto.getApplicationId();
        String showFlag = queryFuncDto.getShowFlag();
        if (HussarUtils.isEmpty((Object)applicationId)) {
            applicationId = 1L;
        }
        String containSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            containSys = "0";
        }
        boolean open = this.secureAssesmentProperties.isOpen();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(APP_ID, applicationId);
        queryParams.put("fromAppId", queryFuncDto.getAppId());
        if ("1".equals(showFlag)) {
            queryParams.put(SHOW_FLAG, showFlag);
        } else {
            queryParams.put(SHOW_FLAG, null);
        }
        if (open) {
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeWithSource(queryParams);
        }
        TranslateUtil.translate(moduleList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        List<Object> result = new ArrayList<JSTreeModel>(moduleList);
        if (open) {
            res = this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionDataForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            res = this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionDataForSource(queryParams);
        }
        TranslateUtil.translate(res, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        result.addAll(res);
        if (!HussarUtils.isNotBlank((CharSequence)functionFlag) || !Boolean.parseBoolean(functionFlag)) {
            result = result.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        if (HussarUtils.isNotEmpty((Object)applicationId)) {
            root.setId(applicationId);
        }
        return LocalFunctionAdapterServiceImpl.filtTreeByAppId(queryFuncDto.getAppId(), result);
    }

    private static List<JSTreeModel> filtTreeByAppId(Long fromAppId, List<JSTreeModel> result) {
        if (HussarUtils.isEmpty((Object)fromAppId) || 1L == fromAppId) {
            return TreeModelUtils.merge(result);
        }
        List filtByAppId = TreeModelUtils.merge(result);
        if (HussarUtils.isEmpty((Object)filtByAppId)) {
            return filtByAppId;
        }
        JSTreeModel tempRoot = (JSTreeModel)filtByAppId.get(0);
        List childLayer1 = tempRoot.getChildrenList();
        for (JSTreeModel child : childLayer1) {
            if (child.getId() != 4L) continue;
            List childLayer2 = child.getChildrenList();
            childLayer2.removeIf(child2 -> !fromAppId.equals(child2.getId()));
        }
        return filtByAppId;
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        SysModuleFunctionsVo sysModuleFunctionsVo = this.sysFunctionsMapper.getFunctionDetail(functionId);
        TranslateUtil.translate((Object)sysModuleFunctionsVo, SysModuleFunctionsVo::getNameLangKey, SysModuleFunctionsVo::setName);
        TranslateUtil.translate((Object)sysModuleFunctionsVo, SysModuleFunctionsVo::getParentNameLangKey, SysModuleFunctionsVo::setParentModuleName);
        TranslateUtil.translate((Object)sysModuleFunctionsVo, SysModuleFunctionsVo::getDefaultResourceNameLangKey, SysModuleFunctionsVo::setDefaultResourceName);
        return sysModuleFunctionsVo;
    }

    public List<SysFunctionModules> moduleList(String moduleName, Long parentModuleId, Long iamAppId, Long businessAppId) {
        if (HussarUtils.isEmpty((Object)iamAppId)) {
            iamAppId = 1L;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(HussarUtils.isNotBlank((CharSequence)moduleName), SysFunctionModules::getFunctionModuleName, (Object)moduleName);
        lambdaQueryWrapper.eq(SysFunctionModules::getParentModuleId, (Object)parentModuleId);
        lambdaQueryWrapper.eq(SysFunctionModules::getApplicationId, (Object)iamAppId);
        lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId);
        lambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        lambdaQueryWrapper.orderByAsc(SysFunctionModules::getSeq);
        return this.localFunctionModuleAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public List<SysFunctionModules> listByCurrentModuleId(Long currentModuleId, Long iamAppId, Long businessAppId) {
        if (HussarUtils.isEmpty((Object)iamAppId)) {
            iamAppId = 1L;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysFunctionModules::getId, (Object)currentModuleId);
        lambdaQueryWrapper.eq(SysFunctionModules::getApplicationId, (Object)iamAppId);
        lambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId);
        lambdaQueryWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        });
        lambdaQueryWrapper.orderByAsc(SysFunctionModules::getSeq);
        return this.localFunctionModuleAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public List<SysFunctionModules> moduleListByAppId(String moduleName, Long parentModuleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(HussarUtils.isNotBlank((CharSequence)moduleName), SysFunctionModules::getFunctionModuleName, (Object)moduleName);
        lambdaQueryWrapper.eq(SysFunctionModules::getParentModuleId, (Object)parentModuleId);
        lambdaQueryWrapper.eq(SysFunctionModules::getAppId, (Object)appId);
        lambdaQueryWrapper.orderByAsc(SysFunctionModules::getSeq);
        return this.localFunctionModuleAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long iamAppId, Long businessAppId) {
        if (HussarUtils.isEmpty((Object)iamAppId)) {
            iamAppId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)iamAppId)).eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        List modules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getFunctionModuleName, (Object)moduleName)).eq(SysFunctionModules::getApplicationId, (Object)iamAppId)).eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })).orderByAsc(SysFunctionModules::getSeq));
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysFunctionModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            result.put(module.getId(), this.toReverseFullName(fullName.toString()));
        }
        return result;
    }

    public Map<Long, String> getFullModuleNameMapByAppId(String moduleName, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        List modules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getFunctionModuleName, (Object)moduleName)).eq(SysFunctionModules::getAppId, (Object)appId)).orderByAsc(SysFunctionModules::getSeq));
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysFunctionModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            result.put(module.getId(), this.toReverseFullName(fullName.toString()));
        }
        return result;
    }

    public String getFullModuleNameById(Long moduleId, Long iamAppId, Long businessAppId) {
        if (HussarUtils.isEmpty((Object)iamAppId)) {
            iamAppId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)iamAppId)).eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        SysFunctionModules module = (SysFunctionModules)this.sysFunctionModulesMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getId, (Object)moduleId)).eq(SysFunctionModules::getApplicationId, (Object)iamAppId)).eq(HussarUtils.isNotEmpty((Object)businessAppId), SysFunctionModules::getAppId, (Object)businessAppId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        return this.toReverseFullName(fullName.toString());
    }

    public String getFullModuleNameByAppId(Long moduleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        SysFunctionModules module = (SysFunctionModules)this.sysFunctionModulesMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getId, (Object)moduleId)).eq(SysFunctionModules::getAppId, (Object)appId));
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        return this.toReverseFullName(fullName.toString());
    }

    private String toReverseFullName(String fullName) {
        String[] parts = fullName.split("/");
        List<String> partList = Arrays.asList(parts);
        Collections.reverse(partList);
        return partList.stream().collect(Collectors.joining("/", "/", ""));
    }

    private void getFullName(Map<Long, SysFunctionModules> moduleMap, SysFunctionModules module, StringBuilder fullName) {
        fullName.append(module.getFunctionModuleName()).append("/");
        Long parentModuleId = module.getParentModuleId();
        if (!HussarUtils.equals((Object)parentModuleId, (Object)PermitConstants.ROOT_PORTAL)) {
            SysFunctionModules parentModule = moduleMap.get(parentModuleId);
            this.getFullName(moduleMap, parentModule, fullName);
        }
    }

    public List<SysFunctions> getFunsByAllDefaultRes(Long appId) {
        return this.sysFunctionsMapper.getFunsByAllDefaultRes(appId);
    }

    public List<JSTreeModel> loadMenuFuncModuleTree(QueryFuncDto queryFuncDto) {
        List<JSTreeModel> functionList;
        List<JSTreeModel> moduleList;
        String menuRelateFlag;
        String functionFlag = queryFuncDto.getFunctionFlag();
        Long appId = queryFuncDto.getApplicationId();
        String string = menuRelateFlag = HussarUtils.isEmpty((Object)queryFuncDto.getMenuRelateFlag()) ? "1" : queryFuncDto.getMenuRelateFlag();
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        String containSys = "";
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            containSys = "0";
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(APP_ID, appId);
        if ("1".equals(queryFuncDto.getShowFlag())) {
            queryParams.put(SHOW_FLAG, queryFuncDto.getShowFlag());
        } else {
            queryParams.put(SHOW_FLAG, null);
        }
        boolean open = this.secureAssesmentProperties.isOpen();
        if (open) {
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            moduleList = this.sysFunctionsMapper.getModuleFunctionTreeWithSource(queryParams);
        }
        TranslateUtil.translate(moduleList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        List<Object> result = new ArrayList<JSTreeModel>();
        if (open) {
            functionList = this.sysFunctionsMapper.getFunctionTreeForSecureAssesment(queryParams);
        } else {
            queryParams.put(CONTAIN_SYS, containSys);
            functionList = this.sysFunctionsMapper.getFunctionTree(queryParams);
        }
        TranslateUtil.translate(functionList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        this.filterFuncIsRelated(functionList, menuRelateFlag, result, moduleList);
        if (!HussarUtils.isNotBlank((CharSequence)functionFlag) || !Boolean.parseBoolean(functionFlag)) {
            result = result.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FUNCTION_MODULE_LIST.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    private void filterFuncIsRelated(List<JSTreeModel> functionList, String menuRelateFlag, List<JSTreeModel> result, List<JSTreeModel> moduleList) {
        if (HussarUtils.isNotEmpty(functionList)) {
            ArrayList<JSTreeModel> finalModuleList = new ArrayList<JSTreeModel>();
            List<Long> moduleIds = new ArrayList<Long>();
            List<Long> funcList = this.sysMenuMapper.getMenuFunctionIds();
            if ("1".equals(menuRelateFlag)) {
                this.showFuncRelatedNoFilter(functionList, result, funcList, moduleIds);
            } else {
                this.showFuncRelatedFilter(functionList, result, funcList, moduleIds);
            }
            moduleIds = moduleIds.stream().distinct().collect(Collectors.toList());
            this.getModuleList(moduleList, moduleIds, finalModuleList);
            List collect = finalModuleList.stream().sorted(Comparator.comparing(JSTreeModel::getParent, Comparator.nullsLast(Long::compareTo)).thenComparing(JSTreeModel::getSeq, Comparator.nullsLast(Comparator.comparingInt(Integer::parseInt)))).collect(Collectors.toList());
            result.addAll(0, collect);
        }
    }

    private void showFuncRelatedFilter(List<JSTreeModel> functionList, List<JSTreeModel> result, List<Long> funcList, List<Long> moduleIds) {
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        for (JSTreeModel model : functionList) {
            Integer bindNum = model.getBindNum();
            if (HussarUtils.isEmpty(funcList)) {
                model.setHidden("1");
                list.add(model);
                moduleIds.add(model.getParent());
            }
            if (!HussarUtils.isNotEmpty(funcList) || Collections.frequency(funcList, model.getId()) >= bindNum) continue;
            model.setHidden("1");
            list.add(model);
            moduleIds.add(model.getParent());
        }
        result.addAll(list);
    }

    private void showFuncRelatedNoFilter(List<JSTreeModel> functionList, List<JSTreeModel> result, List<Long> funcList, List<Long> moduleIds) {
        for (JSTreeModel model : functionList) {
            Integer bindNum = model.getBindNum();
            if (HussarUtils.isNotEmpty(funcList) && Collections.frequency(funcList, model.getId()) >= bindNum) {
                model.setHidden("0");
            } else {
                model.setHidden("1");
            }
            moduleIds.add(model.getParent());
        }
        result.addAll(functionList);
    }

    private void getModuleList(List<JSTreeModel> moduleList, List<Long> moduleIds, List<JSTreeModel> finalModuleList) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        List ids = finalModuleList.stream().map(JSTreeModel::getId).collect(Collectors.toList());
        for (int i = moduleList.size() - 1; i >= 0; --i) {
            JSTreeModel model = moduleList.get(i);
            Long id = model.getId();
            if (!moduleIds.contains(id)) continue;
            Long parentId = model.getParent();
            if (parentId != 1L) {
                parentIds.add(parentId);
            }
            if (ids.contains(id)) continue;
            finalModuleList.add(0, model);
        }
        if (HussarUtils.isNotEmpty(parentIds)) {
            this.getModuleList(moduleList, parentIds, finalModuleList);
        }
    }
}

