/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteFunctionManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.deleteFunctionManagerImpl")
public class DeleteFunctionManagerImpl
implements DeleteFunctionManager {
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Autowired
    private SysFunctionsMapper sysFunctionsMapper;
    @Autowired
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Autowired
    private SysResourcesMapper sysResourcesMapper;
    @Autowired
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Autowired
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Autowired
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Autowired
    private SysRoleDataRightMapper sysRoleDataRightMapper;
    @Autowired
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;

    @Override
    public Boolean deleteAppMenuFuncResByFormId(Long formId) {
        this.sysMenuMapper.deleteById(formId);
        List<Long> funcIds = this.sysFunctionsMapper.selectFuncIdsByModuleId(formId);
        if (HussarUtils.isNotEmpty(funcIds)) {
            this.sysFunctionsMapper.deleteBatchIds(funcIds);
            List<Long> dataRightIds = this.sysRoleDataRightMapper.selectDataRightIdsByFuncIds(funcIds);
            if (HussarUtils.isNotEmpty(dataRightIds)) {
                this.sysRoleStruRightsMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleDataRightsId, dataRightIds));
                this.sysRoleDataRightMapper.deleteBatchIds(dataRightIds);
            }
        }
        List<Long> resourceIds = this.sysResourcesMapper.selectResourceIdsByModuleId(formId);
        this.sysResourcesMapper.deleteBatchIds(resourceIds);
        if (HussarUtils.isNotEmpty(funcIds) || HussarUtils.isNotEmpty(resourceIds)) {
            this.sysFunctionResourcesMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, funcIds)).or()).in(SysFunctionResources::getResourceId, resourceIds));
        }
        this.sysFunctionModulesMapper.deleteById(formId);
        this.sysResourceModulesMapper.deleteById(formId);
        if (HussarUtils.isNotEmpty(funcIds)) {
            this.sysRoleFunctionsMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getFunctionId, funcIds));
        }
        if (HussarUtils.isNotEmpty(resourceIds)) {
            this.sysRoleResourceMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getResourceId, resourceIds));
        }
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
        return Boolean.TRUE;
    }
}

