/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysFunctionResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.manager.AuditResourceManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpandAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysResourcesAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseChangeResourceService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceExpandAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.base.config.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.resourcemanager.ResourceChangeNotify;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataRightFactory;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.auditResourceManagerImpl")
public class AuditResourceManagerImpl
implements AuditResourceManager {
    @Resource
    private SysResourcesAuditMapper sysResourcesAuditMapper;
    @Resource
    private ISysResourceExpandAuditService sysResourceExpandAuditService;
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;
    @Resource
    private ResourceChangeNotify resourceChangeNotify;
    @Resource
    private HussarTenantProperties tenantProperties;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private IHussarBaseChangeResourceService changeResourceService;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private IShortCutConfigService shortCutConfigService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Resource
    private SysFunctionResourcesAuditMapper sysFunctionResourcesAuditMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysResourcesAudit sysResourceAudit = (SysResourcesAudit)this.sysResourcesAuditMapper.selectById(auditId);
        String operateType = sysResourceAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAddPass(sysResourceAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditEditPass(sysResourceAudit);
        } else if ("3".equals(operateType)) {
            result = this.doAuditDeletePass(sysResourceAudit);
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UNSUPPORTED_OPERATION_TYPE.getMessage()));
        }
        return result;
    }

    private Boolean doAuditDeletePass(SysResourcesAudit sysResourceAudit) {
        Long resourceId = sysResourceAudit.getResourceId();
        this.sysRoleResourceMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId));
        SysResources resource = (SysResources)this.sysResourcesMapper.selectById(resourceId);
        if (HussarUtils.equals((Object)"res_menu", (Object)resource.getResTypeId()) || HussarUtils.equals((Object)"res_element", (Object)resource.getResTypeId())) {
            List sysResources = this.sysResourcesService.getPageAndElementResources(resource.getModuleId());
            HashSet<Long> resIds = new HashSet<Long>();
            this.getChildElementResources(resourceId, sysResources, resIds);
            if (HussarUtils.isNotEmpty(resIds)) {
                this.sysResourcesService.removeByIds(resIds);
                this.sysRoleResourceMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getResourceId, resIds));
            }
        }
        this.sysResourcesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resourceId));
        this.hussarBaseResourceExpandService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)resourceId));
        this.sysResourceExpandAuditService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysResourceExpandAudit::getAuditStatus, (Object)"1")).eq(SysResourceExpandAudit::getAuditStatus, (Object)"0")).eq(SysResourceExpandAudit::getResourceId, (Object)resourceId));
        this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getResourceId, (Object)resourceId));
        this.sysFunctionResourcesAuditMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResourcesAudit::getAuditStatus, (Object)"0")).eq(SysFunctionResourcesAudit::getResourceId, (Object)resourceId));
        if (HussarUtils.isNotEmpty((Object)resource.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)resource.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.DELETE, new Object[]{resource});
        }
        sysResourceAudit.setAuditStatus("1");
        return this.sysResourcesAuditMapper.updateById(sysResourceAudit) > 0;
    }

    private void getChildElementResources(Long resourceId, List<SysResources> resources, Set<Long> resIds) {
        List childResources = resources.stream().filter(r -> HussarUtils.equals((Object)resourceId, (Object)r.getParentResourceId())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(childResources)) {
            for (SysResources child : childResources) {
                resIds.add(child.getId());
                this.getChildElementResources(child.getId(), resources, resIds);
            }
        }
    }

    private Boolean doAuditEditPass(SysResourcesAudit sysResourceAudit) {
        sysResourceAudit.setAuditStatus("1");
        Long resourceId = sysResourceAudit.getResourceId();
        SysResources sysResources = new SysResources();
        BeanUtils.copyProperties((Object)sysResourceAudit, (Object)sysResources, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
        sysResources.setId(resourceId);
        sysResources.setUserRight(sysResourceAudit.getUserRights());
        sysResources.setDeptRight(sysResourceAudit.getDeptRights());
        this.hussarBaseResourceExpandService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpand::getResourceId, (Object)sysResources.getId()));
        this.sysResourcesMapper.updateById(sysResources);
        List sysFunctions = this.sysFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getDefaultResourceId, (Object)sysResources.getId()));
        if (HussarUtils.isNotEmpty((Object)sysFunctions)) {
            for (int i = 0; i < sysFunctions.size(); ++i) {
                SysFunctions sysFunction = (SysFunctions)sysFunctions.get(i);
                ShortCutConfig shortCutConfig = (ShortCutConfig)this.shortCutConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ShortCutConfig::getFunctionId, (Object)sysFunction.getId()));
                if (!HussarUtils.isNotEmpty((Object)shortCutConfig)) continue;
                shortCutConfig.setShortCutUrl(sysResources.getPath());
                if (this.shortCutConfigService.updateById((Object)shortCutConfig)) continue;
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
            }
        }
        this.handleResourceExpand(resourceId);
        List resourceTypeCodes = DataRightFactory.getResourceTypeCodes();
        resourceTypeCodes.add("res_rights");
        if (resourceTypeCodes.contains(sysResources.getResTypeId())) {
            LambdaQueryWrapper roleResourceLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)roleResourceLambdaQueryWrapper.eq(SysRoleResource::getResourceId, (Object)sysResources.getId())).eq(SysRoleResource::getRelationSource, (Object)"1");
            List roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)roleResourceLambdaQueryWrapper);
            List<Long> roleIdList = roleResourceList.stream().map(SysRoleResource::getRoleId).distinct().collect(Collectors.toList());
            this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
        }
        this.handleTenantCache(sysResources);
        SysResources newResource = (SysResources)this.sysResourcesMapper.selectById(sysResources.getId());
        if (HussarUtils.isNotEmpty((Object)newResource.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)newResource.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.UPDATE, new Object[]{newResource});
        }
        return this.sysResourcesAuditMapper.updateById(sysResourceAudit) > 0;
    }

    private void handleTenantCache(SysResources sysResources) {
        if (this.tenantProperties.isEnabled() && ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName().equals("master")) {
            Executor hussarBaseAuthorizationExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            hussarBaseAuthorizationExecutor.execute(() -> {
                String cacheName = "tenant_info";
                List cacheKeys = HussarFixedCacheUtil.getKeysLike((String)cacheName, (String)"?");
                for (String cacheKey : cacheKeys) {
                    HussarTenantDefinition definition = (HussarTenantDefinition)HussarFixedCacheUtil.get((String)cacheName, (Object)cacheKey);
                    if (!HussarUtils.isNotEmpty((Object)definition)) continue;
                    HussarContextHolder.setTenant((String)definition.getConnName(), (String)definition.getTenantCode());
                    this.changeResourceService.saveResource(definition.getConnName(), sysResources);
                    HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
                }
            });
        }
    }

    private void handleResourceExpand(Long resourceId) {
        List resExpandAuditList = this.sysResourceExpandAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceExpandAudit::getResourceId, (Object)resourceId)).eq(SysResourceExpandAudit::getAuditStatus, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)resExpandAuditList)) {
            ArrayList<SysResourceExpand> resourceExpandList = new ArrayList<SysResourceExpand>();
            for (SysResourceExpandAudit audit : resExpandAuditList) {
                SysResourceExpand resourceExpand = new SysResourceExpand();
                BeanUtils.copyProperties((Object)audit, (Object)resourceExpand, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
                resourceExpandList.add(resourceExpand);
            }
            this.hussarBaseResourceExpandService.saveBatch(resourceExpandList, resourceExpandList.size());
            this.sysResourceExpandAuditService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysResourceExpandAudit::getAuditStatus, (Object)"1")).eq(SysResourceExpandAudit::getAuditStatus, (Object)"0")).eq(SysResourceExpandAudit::getResourceId, (Object)resourceId));
        }
    }

    private Boolean doAuditAddPass(SysResourcesAudit sysResourceAudit) {
        sysResourceAudit.setAuditStatus("1");
        Long resourceId = sysResourceAudit.getResourceId();
        SysResources sysResources = new SysResources();
        BeanUtils.copyProperties((Object)sysResourceAudit, (Object)sysResources, (String[])new String[]{"id", "createTime", "lastTime", "creator", "lastEditor"});
        sysResources.setId(resourceId);
        sysResources.setUserRight(sysResourceAudit.getUserRights());
        sysResources.setDeptRight(sysResourceAudit.getDeptRights());
        this.handleResourceExpand(resourceId);
        this.sysResourcesMapper.insert(sysResources);
        this.handleTenantCache(sysResources);
        if (HussarUtils.isNotEmpty((Object)sysResources.getApplicationId()) && !HussarUtils.equals((Object)1L, (Object)sysResources.getApplicationId())) {
            this.resourceChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysResources});
        }
        return this.sysResourcesAuditMapper.updateById(sysResourceAudit) > 0;
    }

    @Override
    public Boolean reject(Long auditId) {
        boolean result;
        SysResourcesAudit sysResourceAudit = (SysResourcesAudit)this.sysResourcesAuditMapper.selectById(auditId);
        String operateType = sysResourceAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAddReject(sysResourceAudit);
        } else {
            sysResourceAudit.setAuditStatus("2");
            result = this.sysResourcesAuditMapper.updateById(sysResourceAudit) > 0;
        }
        return result;
    }

    private Boolean doAuditAddReject(SysResourcesAudit sysResourceAudit) {
        sysResourceAudit.setAuditStatus("2");
        Long resourceId = sysResourceAudit.getResourceId();
        this.sysResourceExpandAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceExpandAudit::getResourceId, (Object)resourceId));
        return this.sysResourcesAuditMapper.updateById(sysResourceAudit) > 0;
    }
}

