/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentBusiTypeEnum;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentFileTypeEnum;
import com.jxdinfo.hussar.authorization.permit.manager.AddUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserAttachment;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersAdditionalInfo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersAddtionalInfoService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.addUserManagerImpl")
public class AddUserManagerImpl
extends CommonUserManager
implements AddUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddUserManagerImpl.class);
    @Autowired
    private ValidateUserManager validateUserManager;
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;
    @Autowired
    private ISysUsersAddtionalInfoService sysUsersAddtionalInfoService;
    @Autowired(required=false)
    private IHussarBaseTenantService hussarBaseTenantService;

    @Override
    public ApiResponse<Long> addUser(AddUserDto addUserDto) {
        String tenantType;
        this.validateUserManager.validateLimit();
        String validateMsg = this.validateService.validate((Object)addUserDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String allowedIps = StringUtils.trimToEmpty((String)addUserDto.getAllowedIps());
        String roleIds = StringUtils.trimToEmpty((String)addUserDto.getRoleIds());
        ArrayList<Object> listRoles = new ArrayList<Object>();
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            Object[] temp = (Long[])ConvertUtils.convert((String[])roleIds.split(","), Long.class);
            if (!ArrayUtils.contains((Object[])temp, (Object)SysUserAndRole.PUBLIC_ROLE.getValue())) {
                listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
            }
            listRoles.addAll(Arrays.asList(temp));
        } else {
            listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
        }
        Long[] roleIdsArray = listRoles.toArray(new Long[0]);
        SysUsers user = this.initialization(addUserDto);
        this.handleRelation(user, addUserDto);
        boolean tenantFlag = this.isCanAdd(user);
        this.checkIncludeConfRole(roleIdsArray, "add");
        this.userAuditDataExists(user.getUserAccount());
        String secure = this.wrapUser(user);
        String result = this.processAuditIfNecessary(tenantFlag, user, allowedIps, roleIdsArray, secure);
        if (addUserDto.getUserSignFileId() != null && addUserDto.getUserSignFileId() > 0L) {
            this.saveUserSignPic(addUserDto, user.getId());
        }
        if ("onsystem".equals(tenantType = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("hussar.core.tenant.type")) && HussarUtils.isNotEmpty((Object)addUserDto.getGitToken())) {
            this.saveUserGitToken(addUserDto, user.getId());
        }
        return ApiResponse.success((Object)user.getId(), (String)result);
    }

    private String processAuditIfNecessary(boolean tenantFlag, SysUsers sysUsers, String allowedIps, Long[] roleIds, String secure) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AUDIT_CONSTANT_2.getMessage()));
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.doProcessUserAudit(sysUsers, allowedIps, roleIds);
        } else {
            this.doProcessUser(tenantFlag, sysUsers, allowedIps, roleIds, secure);
        }
        boolean userRoleAuditFlag = false;
        Long sysUsersId = sysUsers.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUsersId);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            this.sysUserRoleService.save((Object)sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                    if (SysUserAndRole.GRADEADMIN_ROLE.getValue().equals(roleId)) {
                        SysUserRole sysUserGradeRole = new SysUserRole();
                        sysUserGradeRole.setUserId(sysUsersId);
                        sysUserGradeRole.setGrantedRole(SysUserAndRole.GRADEADMIN_ROLE.getValue());
                        sysUserGradeRole.setAdminOption(UserRoleStatus.OK.getCode());
                        this.sysUserRoleService.save((Object)sysUserGradeRole);
                        continue;
                    }
                    userRoleAuditFlag = true;
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsersId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType("1");
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (HussarUtils.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
        } else if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit() && userRoleAuditFlag) {
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
        } else {
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
        }
        return stringBuilder.toString();
    }

    private void doProcessUser(boolean tenantFlag, SysUsers sysUsers, String allowedIps, Long[] roleIds, String secure) {
        String mobile = sysUsers.getMobile();
        String telephone = sysUsers.getTelephone();
        this.sysUsersMapper.insert(sysUsers);
        this.saveUserIP(sysUsers.getId(), allowedIps);
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUsers.getId());
                    sysUserRole.setGrantedRole(roleId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.fillCommonFields(userRoleList);
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
        }
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        HashMap<String, String> expansionMap = new HashMap<String, String>();
        expansionMap.put("allowIp", allowedIps);
        sysUsers.setExpansionMap(expansionMap);
        this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysUsers});
    }

    private void doProcessUserAudit(SysUsers sysUsers, String allowedIps, Long[] roleIds) {
        boolean canOperate = this.sysStruAuditService.checkCanOperate(sysUsers.getDepartmentId());
        AssertUtil.isTrue((boolean)canOperate, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_USER_ORGAN_EXIST_UNAPPROVED_DATA.getMessage()));
        long userId = sysUsers.getId();
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsersAudit.setId(null);
        sysUsersAudit.setUserId(Long.valueOf(userId));
        sysUsersAudit.setPassword(sysUsers.getPassword());
        sysUsersAudit.setCurrentStatus("0");
        sysUsersAudit.setIsAudit("0");
        LocalDateTime now = LocalDateTime.now();
        sysUsersAudit.setCreateTime(now);
        sysUsersAudit.setCreateTime(now);
        if (HussarUtils.isNotEmpty((Object)sysUsers.getExpansionMap())) {
            sysUsersAudit.setExpansionMap(sysUsers.getExpansionMap());
        }
        this.sysUsersAuditService.save((Object)sysUsersAudit);
        this.saveUserAuditIP(userId, allowedIps, "0");
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(Long.valueOf(userId));
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            this.sysUserRoleService.save((Object)sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId) || Objects.equals(roleId, SysUserAndRole.PUBLIC_ROLE.getValue())) continue;
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsers.getId());
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.UserAuditButRoleNotAudit.getCode());
                    sysUserroleAudit.setOperationType("1");
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        }
    }

    private String wrapUser(SysUsers sysUsers) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FILL_IN_USER_INFO.getMessage()));
        sysUsers.setCorporationId(sysUsers.getDepartmentId());
        sysUsers.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        String secure = "";
        String encodeSecure = "";
        secure = this.hussarPwdConfigService.getDefaultPassword();
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue()) {
            AssertUtil.isNotEmpty((String)sysUsers.geteMail(), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CREATE_USER_MAST_SEND_EMAIL.getMessage()));
            if (!this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
                secure = GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule());
            }
        }
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isUserAudit()) {
            encodeSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
            sysUsers.setPassword(encodeSecure);
        } else {
            sysUsers.setPassword(secure);
        }
        return secure;
    }

    private void userAuditDataExists(String userAccount) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_VERIFY_AUDIT.getMessage()));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        boolean userAccountInAudit = this.sysUsersAuditService.count((Wrapper)wrapper) > 0L;
        AssertUtil.isFalse((boolean)userAccountInAudit, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST_AUDIT.getMessage()));
    }

    private SysUsers initialization(AddUserDto addUserDto) {
        String struIds;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_DTO_INITIALIZE_PARAM.getMessage()), (Object)JSON.toJSONString((Object)addUserDto));
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        String userAccount = StringUtils.trimToEmpty((String)addUserDto.getUserAccount());
        Long employeeId = addUserDto.getEmployeeId();
        if (HussarUtils.isNotEmpty((Object)addUserDto.getUserSecurityLevel())) {
            Integer userSecurityLevel = Integer.valueOf(addUserDto.getUserSecurityLevel());
            user.setSecurityLevel(userSecurityLevel);
        }
        String mail = StringUtils.trimToEmpty((String)addUserDto.getMail());
        Integer maxSessions = addUserDto.getMaxSessions();
        String weChat = StringUtils.trimToEmpty((String)addUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)addUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)addUserDto.getTelephone());
        String accountStatus = StringUtils.trimToEmpty((String)addUserDto.getAccountStatus());
        String accountProperty = StringUtils.trimToEmpty((String)addUserDto.getAccountProperty());
        boolean isLoginTimeLimit = addUserDto.getLoginTimeLimit();
        String accessLoginStartTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginEndTime());
        String startTime = StringUtils.trimToEmpty((String)addUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)addUserDto.getEndTime());
        boolean isLoginIpLimit = addUserDto.getLoginIpLimit();
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)employeeId);
        AssertUtil.isNotNull((Object)sysStaff, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_NO_EXIST_STAFF.getMessage()));
        List sysUsers = this.sysUsersMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)employeeId)).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_USER.getMessage()));
        }
        List usersAudits = this.sysUsersAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsersAudit::getEmployeeId, (Object)employeeId)).eq(SysUsersAudit::getIsAudit, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)usersAudits)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_USER_REVIEW.getMessage()));
        }
        user.setUserName(sysStaff.getName());
        user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(sysStaff.getName()));
        user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(sysStaff.getName()));
        user.setUserAccount(userAccount);
        user.seteMail(mail);
        user.setAccountStatus(accountStatus);
        user.setEmployeeId(employeeId);
        user.setTypeProperty(accountProperty);
        user.setSecurityLevel(Integer.valueOf(1));
        if (HussarUtils.isNotEmpty((Object)addUserDto.getUserSecurityLevel())) {
            Integer userSecurityLevel = Integer.valueOf(addUserDto.getUserSecurityLevel());
            user.setSecurityLevel(userSecurityLevel);
        }
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setLoginTimeLimit(isLoginTimeLimit ? "1" : "0");
        user.setLoginIpLimit(isLoginIpLimit ? "1" : "0");
        user.setExpansionMap(HussarUtils.isEmpty((Object)addUserDto.getExpansionMap()) ? null : addUserDto.getExpansionMap());
        Integer userOrder = this.sysUsersMapper.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        if (HussarUtils.isNotBlank((CharSequence)(struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds())))) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            user.setCorporationId(temp[0]);
            user.setDepartmentId(temp[0]);
        }
        return user;
    }

    private boolean isCanAdd(SysUsers sysUsers) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ADD_VERIFY.getMessage()));
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAudit::getRealStruId, (Object)sysUsers.getEmployeeId())).eq(SysStruAudit::getState, (Object)"0");
        Long count = this.sysStruAuditMapper.selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THIS_PERSON_PROHIBIT_UPDATE.getMessage()));
        }
        return true;
    }

    private boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }

    private void handleRelation(SysUsers user, AddUserDto addUserDto) {
        Long userId = user.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.saveUserPostAudit(addUserDto, userId);
            this.saveStruUserAudit(addUserDto, userId);
        } else {
            this.saveStruUser(addUserDto, userId);
            this.saveUserPost(addUserDto, userId);
        }
    }

    private void saveStruUser(AddUserDto addUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        LocalDateTime now = LocalDateTime.now();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        for (Long struId : struIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUser.setCreateTime(now);
            struUser.setLastTime(now);
            struUser.setCreator(securityUser.getId());
            struUser.setLastEditor(securityUser.getId());
            struUsers.add(struUser);
        }
        if (HussarUtils.isNotEmpty(struUsers)) {
            this.sysStruUserService.saveBatch(struUsers, struUsers.size());
        }
    }

    private void saveUserPost(AddUserDto addUserDto, Long userId) {
        ArrayList<SysUserPost> userPosts = new ArrayList<SysUserPost>();
        Long postId = addUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPost userPost = new SysUserPost();
            userPost.setPostId(postId);
            userPost.setUserId(userId);
            userPost.setRelateType("0");
            userPosts.add(userPost);
        }
        String partPostIds = StringUtils.trimToEmpty((String)addUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPost userPost = new SysUserPost();
                userPost.setPostId(partPostId);
                userPost.setUserId(userId);
                userPost.setRelateType("1");
                userPosts.add(userPost);
            }
        }
        if (HussarUtils.isNotEmpty(userPosts)) {
            this.sysUserPostService.saveBatch(userPosts, userPosts.size());
        }
    }

    private void saveUserPostAudit(AddUserDto addUserDto, Long userId) {
        ArrayList<SysUserPostAudit> userPostAudits = new ArrayList<SysUserPostAudit>();
        Long postId = addUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPostAudit userPostAudit = new SysUserPostAudit();
            userPostAudit.setPostId(postId);
            userPostAudit.setUserId(userId);
            userPostAudit.setRelateType("0");
            userPostAudit.setOperateType("1");
            userPostAudit.setAuditStatus("0");
            userPostAudits.add(userPostAudit);
        }
        String partPostIds = StringUtils.trimToEmpty((String)addUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPostAudit userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(partPostId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType("1");
                userPostAudit.setOperateType("1");
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(userPostAudits)) {
            this.sysUserPostAuditService.saveBatch(userPostAudits, userPostAudits.size());
        }
    }

    private void saveStruUserAudit(AddUserDto addUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        ArrayList<SysStruUserAudit> sysStruUserAudits = new ArrayList<SysStruUserAudit>();
        if (HussarUtils.isNotEmpty(struIdList)) {
            for (Long struId : struIdList) {
                SysStruUserAudit sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType("1");
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(sysStruUserAudits)) {
            this.sysStruUserAuditService.saveBatch(sysStruUserAudits, sysStruUserAudits.size());
        }
    }

    private void saveUserSignPic(AddUserDto addUserDto, Long userId) {
        SysUserAttachment sysUserAttachment = new SysUserAttachment();
        sysUserAttachment.setFileType(Integer.valueOf(UserAttachmentFileTypeEnum.ATTACHMENT_FILE.getValue()));
        sysUserAttachment.setBusiType(Integer.valueOf(UserAttachmentBusiTypeEnum.USER_SIGN.getValue()));
        sysUserAttachment.setFileId(addUserDto.getUserSignFileId());
        sysUserAttachment.setUserId(userId);
        this.userAttachmentService.saveUserAttachmentInfo(sysUserAttachment);
    }

    private void saveUserGitToken(AddUserDto addUserDto, Long userId) {
        SysUsersAdditionalInfo sysUsersAdditionalInfo = new SysUsersAdditionalInfo();
        sysUsersAdditionalInfo.setUserId(userId);
        sysUsersAdditionalInfo.setGitToken(addUserDto.getGitToken());
        this.sysUsersAddtionalInfoService.save((Object)sysUsersAdditionalInfo);
    }
}

