/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.adapter.organ.IHussarBaseOrganizationAdapter;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganTypeDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganTypeAudit;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeAuditService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTypeTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysPostAudit;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostAuditService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOrganTypeServiceImpl
extends HussarServiceImpl<SysOrganTypeMapper, SysOrganType>
implements ISysOrganTypeService {
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private ISysStruRuleService isSysStruRuleService;
    @Resource
    private IHussarBasePostService hussarBasePostService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysStruAuditService sysStruAuditService;
    @Autowired
    private ISysPostAuditService sysPostAuditService;
    @Autowired
    private IHussarBaseOrganizationAdapter hussarBaseOrganizationAdapter;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    private ISysAuditConfigService sysAuditConfigService;
    @Autowired
    private ISysOrganTypeAuditService sysOrganTypeAuditService;

    public IPage<SysOrganTypeVo> getOrganTypeList(Page<SysOrganTypeVo> page, SysOrganType sysOrganType) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PAGING_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysOrganType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_DEFINITION_DTO_EMPTY.getMessage()));
        }
        page.setRecords(this.sysOrganTypeMapper.getOrganTypeList(page, sysOrganType));
        return page;
    }

    public List<SysOrganType> getOrgTypeOption() {
        return this.sysOrganTypeMapper.getOrgTypeOption();
    }

    public SysOrganType getSysOrganTypeByTypeCode(String typeCode) {
        if (HussarUtils.isNotBlank((CharSequence)typeCode)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysOrganType::getOrganType, (Object)typeCode);
            return (SysOrganType)this.getOne((Wrapper)lambdaQueryWrapper, false);
        }
        return null;
    }

    @HussarTransactional
    public ApiResponse updateSysOrganType(SysOrganTypeDto sysOrganTypeDto) {
        List orgList;
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_DTO_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOrganType())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOldOrgName()) || ToolUtil.isEmpty((Object)sysOrganTypeDto.getTypeName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_OR_TYPE_NAME_EMPTY.getMessage()));
        }
        String parentType = HussarUtils.isNotBlank((CharSequence)sysOrganTypeDto.getParentType()) ? sysOrganTypeDto.getParentType() : "0";
        sysOrganTypeDto.setParentType(parentType);
        SysOrganType type = (SysOrganType)this.getById(sysOrganTypeDto.getId());
        if (!type.getParentType().equals(sysOrganTypeDto.getParentType())) {
            String organType = type.getOrganType();
            List topOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruRule::getSysOrganType, (Object)organType));
            List dowOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruRule::getOrganType, (Object)organType));
            List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPost::getOrganTypeCode, (Object)organType)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List strus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().eq(SysStru::getStruType, (Object)organType));
            List struAudits = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruAudit::getStruType, (Object)organType)).eq(SysStruAudit::getState, (Object)"0"));
            List postAudits = this.sysPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPostAudit::getOrganTypeCode, (Object)organType)).eq(SysPostAudit::getAuditStatus, (Object)"0")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (topOrg.size() + dowOrg.size() + posts.size() + strus.size() + struAudits.size() + postAudits.size() != 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_PARENT_FAIL_ORGANIZATIONAL_TYPE_APPLICATION.getMessage()));
            }
        }
        SysOrganType sysOrganType = new SysOrganType();
        BeanUtils.copyProperties((Object)sysOrganTypeDto, (Object)sysOrganType);
        if (!sysOrganTypeDto.getTypeName().equals(sysOrganTypeDto.getOldOrgName()) && (orgList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getTypeName, (Object)sysOrganTypeDto.getTypeName()))).size() != 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATIONAL_TYPE_NAME_EXIST.getMessage()));
        }
        sysOrganType.setIsSystem(null);
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isOrganTypeAudit()) {
            this.checkSysOrganTypeAuditDataExists("2", Lists.newArrayList((Object[])new Long[]{sysOrganType.getId()}));
            return ApiResponse.success((String)this.doSaveSysOrganTypeAudit(Lists.newArrayList((Object[])new SysOrganType[]{sysOrganType}), "2"));
        }
        boolean flag = this.updateById((BaseEntity)sysOrganType);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
        }
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "update", (Object)sysOrganType, Constants.NONE_ID);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse saveSysOrganType(SysOrganType sysOrganType) {
        if (ToolUtil.isEmpty((Object)sysOrganType)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_OBJECT_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysOrganType.getOrganType())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
        }
        if (ToolUtil.isEmpty((Object)sysOrganType.getTypeName())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_NAME_EMPTY.getMessage()));
        }
        if ("0".equals(sysOrganType.getOrganType())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CLASS_NAME_CODE_ZERO.getMessage()));
        }
        SysOrganType org = this.getSysOrganTypeByTypeCode(sysOrganType.getOrganType());
        if (org != null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_ADD_ORGANIZATIONAL_TYPE_CODE_EXIST.getMessage()));
        }
        List orgList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getTypeName, (Object)sysOrganType.getTypeName()));
        if (orgList.size() != 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_ADD_ORGANIZATIONAL_TYPE_NAME_EXIST.getMessage()));
        }
        sysOrganType.setInUse("1");
        sysOrganType.setIsSystem("0");
        if (HussarUtils.isEmpty((Object)sysOrganType.getParentType())) {
            sysOrganType.setParentType("0");
        }
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isOrganTypeAudit()) {
            this.parentOrganTypeAuditDataExists(sysOrganType.getParentType());
            return ApiResponse.success((String)this.doSaveSysOrganTypeAudit(Lists.newArrayList((Object[])new SysOrganType[]{sysOrganType}), "1"));
        }
        return ApiResponse.success((String)this.doSaveSysOrganType(sysOrganType));
    }

    private void parentOrganTypeAuditDataExists(String parentOrganType) {
        SysOrganTypeAudit existSysOrganTypeAudit = (SysOrganTypeAudit)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysOrganTypeAuditService.lambdaQuery().eq(SysOrganTypeAudit::getOrganType, (Object)parentOrganType)).eq(SysOrganTypeAudit::getOperateType, (Object)"0")).one();
        if (existSysOrganTypeAudit != null) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u65b0\u589e\u7ec4\u7ec7\u7c7b\u578b\u7684\u7236\u7ea7\u7ec4\u7ec7\u7c7b\u578b\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
        }
    }

    private String doSaveSysOrganType(SysOrganType sysOrganType) {
        boolean flag = this.save((BaseEntity)sysOrganType);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_FAIL.getMessage()));
        }
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "add", (Object)sysOrganType, Constants.NONE_ID);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.SAVE_SUCCESS.getMessage());
    }

    @HussarTransactional
    public ApiResponse deleteByIds(String ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_ID_DEL_EMPTY.getMessage()));
        }
        List<Long> idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        List typeList = this.list((Wrapper)new LambdaQueryWrapper().in(SysOrganType::getId, idList)).stream().map(SysOrganType::getOrganType).collect(Collectors.toList());
        List orgList = this.list((Wrapper)new LambdaQueryWrapper().in(SysOrganType::getParentType, typeList));
        List topOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRule::getSysOrganType, typeList));
        List dowOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRule::getOrganType, typeList));
        List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPost::getOrganTypeCode, typeList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List strus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getStruType, typeList));
        List struAudits = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getStruType, typeList)).eq(SysStruAudit::getState, (Object)"0"));
        List postAudits = this.sysPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPostAudit::getOrganTypeCode, typeList)).eq(SysPostAudit::getAuditStatus, (Object)"0")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (orgList.size() + topOrg.size() + dowOrg.size() + posts.size() + strus.size() + struAudits.size() + postAudits.size() != 0) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_DELETE_FAIL_ORGANIZATIONAL_TYPE_APPLICATION.getMessage()));
        }
        List sysOrganTypeList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(SysOrganType::getId, idList)).list();
        if (this.sysAuditConfigService.isCriticalOperationsAudit() && this.sysAuditConfigService.isOrganTypeAudit()) {
            this.checkSysOrganTypeAuditDataExists("3", idList);
            return ApiResponse.success((String)this.doSaveSysOrganTypeAudit(sysOrganTypeList, "3"));
        }
        boolean flag = this.removeByIds(idList);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_FAIL.getMessage()));
        }
        JSONObject typeIds = new JSONObject();
        typeIds.put("idList", idList);
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "delete", (Object)typeIds, Constants.NONE_ID);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DELETE_SUCCESS.getMessage()));
    }

    private String doSaveSysOrganTypeAudit(List<SysOrganType> sysOrganTypeList, String operateType) {
        String result;
        String inUse;
        LocalDateTime now = LocalDateTime.now();
        ArrayList<SysOrganTypeAudit> sysOrganTypeAuditList = new ArrayList<SysOrganTypeAudit>();
        switch (operateType) {
            case "1": {
                inUse = "1";
                result = TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage());
                break;
            }
            case "2": {
                inUse = "2";
                result = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
                break;
            }
            default: {
                inUse = "3";
                result = TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_SUCCESS_WAIT_REVIEW.getMessage());
            }
        }
        for (SysOrganType sysOrganType : sysOrganTypeList) {
            SysOrganTypeAudit sysOrganTypeAudit = new SysOrganTypeAudit();
            sysOrganTypeAudit.setTypeId(sysOrganType.getId());
            sysOrganTypeAudit.setAuditStatus("0");
            sysOrganTypeAudit.setOperateType(operateType);
            sysOrganTypeAudit.setInUse(inUse);
            sysOrganTypeAudit.setIsSystem(sysOrganType.getIsSystem());
            sysOrganTypeAudit.setOrganType(sysOrganType.getOrganType());
            sysOrganTypeAudit.setTypeName(sysOrganType.getTypeName());
            sysOrganTypeAudit.setParentType(sysOrganType.getParentType());
            sysOrganTypeAudit.setImgUrl(sysOrganType.getImgUrl());
            sysOrganTypeAudit.setCreator(BaseSecurityUtil.getUser().getId());
            sysOrganTypeAudit.setCreateTime(now);
            sysOrganTypeAudit.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysOrganTypeAudit.setLastTime(now);
            sysOrganTypeAuditList.add(sysOrganTypeAudit);
        }
        this.sysOrganTypeAuditService.saveBatch(sysOrganTypeAuditList);
        return result;
    }

    public void checkSysOrganTypeAuditDataExists(String operateType, List<Long> sysOrganTypeIds) {
        String errorMsg;
        List sysOrganTypeAuditList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysOrganTypeAuditService.lambdaQuery().in(SysOrganTypeAudit::getTypeId, sysOrganTypeIds)).eq(SysOrganTypeAudit::getAuditStatus, (Object)"0")).list();
        switch (operateType) {
            case "2": {
                errorMsg = TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage());
                break;
            }
            default: {
                errorMsg = TranslateUtil.getTranslateName((String)TipConstantsEnum.DELETE_FAIL_EXIST_REVIEW.getMessage());
            }
        }
        if (HussarUtils.isNotEmpty((Object)sysOrganTypeAuditList)) {
            throw new BaseException(errorMsg);
        }
    }

    public void checkOrganTypeInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": {
                SysOrganType sysOrganType = (SysOrganType)JSON.parseObject((String)JSON.toJSONString((Object)object), SysOrganType.class);
                if (ToolUtil.isEmpty((Object)sysOrganType)) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_TYPE_DEFINITION_CANNOT_BE_EMPTY.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysOrganType.getTypeName().trim())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_NAME_EMPTY.getMessage()));
                } else if (sysOrganType.getTypeName().trim().length() > 32) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_UP_32_CHARACTERS_FOR_ORGAN_TYPE_NAME.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysOrganType.getOrganType())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
                } else if (String.valueOf(sysOrganType.getOrganType()).length() > 10) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_UP_10_DIGITS_FOR_ORGAN_TYPE_CODE.getMessage()));
                }
                String validateAddMsg = this.validateService.validate((Object)sysOrganType);
                if (ToolUtil.isEmpty((Object)validateAddMsg)) break;
                messageList.add(validateAddMsg);
                break;
            }
            case "edit": {
                SysOrganTypeDto sysOrganTypeDto = (SysOrganTypeDto)JSON.parseObject((String)JSON.toJSONString((Object)object), SysOrganTypeDto.class);
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto)) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_DEFINITION_DTO_EMPTY.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOldOrgName())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_OLD_ORGAN_NAME_NOT_FILLED.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getTypeName().trim())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_NAME_EMPTY.getMessage()));
                } else if (sysOrganTypeDto.getTypeName().trim().length() > 32) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_UP_32_CHARACTERS_FOR_ORGAN_TYPE_NAME.getMessage()));
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOrganType())) {
                    messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_CODE_EMPTY.getMessage()));
                    break;
                }
                if (String.valueOf(sysOrganTypeDto.getOrganType()).length() <= 10) break;
                messageList.add(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_UP_10_DIGITS_FOR_ORGAN_TYPE_CODE.getMessage()));
                break;
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }

    public List<SysOrganType> getOrgTypeExcludeStaff() {
        List<SysOrganType> list = this.sysOrganTypeMapper.getOrgTypeExcludeStaff();
        return list;
    }

    public Map<String, SysOrganType> queryOrganTypeMap() {
        List listOrganType = this.sysOrganTypeMapper.selectList(null);
        return listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
    }

    public String getDeptIcon(Long deptId) {
        return this.hussarBaseOrganizationAdapter.getDeptIcon(deptId);
    }

    public List<SysOrganType> getOrganTypeByOrganTypeIds(List<Long> organTypeIds) {
        if (HussarUtils.isEmpty(organTypeIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : organTypeIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysOrganType::getId, (Object)id);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public Map<String, Integer> saveOrUpdateOrganTypeList(List<SysOrganType> organTypes) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List typeIds = organTypes.stream().map(SysOrganType::getId).collect(Collectors.toList());
        List existedTypes = new ArrayList();
        if (ToolUtil.isNotEmpty(typeIds)) {
            existedTypes = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOrganType::getId, typeIds));
        }
        ArrayList<SysOrganType> repeatTypes = new ArrayList<SysOrganType>();
        ArrayList<SysOrganType> newTypes = new ArrayList<SysOrganType>();
        if (HussarUtils.isNotEmpty(existedTypes)) {
            List repeatIds = existedTypes.stream().map(SysOrganType::getId).collect(Collectors.toList());
            for (SysOrganType type : organTypes) {
                if (repeatIds.contains(type.getId())) {
                    repeatTypes.add(type);
                    continue;
                }
                newTypes.add(type);
            }
            map.put("insert", newTypes.size());
            map.put("update", repeatTypes.size());
            this.saveBatch(newTypes);
            this.updateBatchById(repeatTypes);
        } else {
            this.saveBatch(organTypes);
            map.put("insert", organTypes.size());
            map.put("update", 0);
        }
        return map;
    }

    public List<SysOrganType> getParentOrganTypesByOrganTypeName(String organTypeName) {
        return this.sysOrganTypeMapper.getParentOrganTypesByOrganTypeName(organTypeName);
    }

    public List<SysOrganType> getEditOrgTypeOption(String organType) {
        ArrayList<SysOrganType> result = new ArrayList<SysOrganType>();
        List types = this.sysOrganTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().orderByAsc(SysOrganType::getOrganType));
        ArrayList<String> typeTree = new ArrayList<String>();
        typeTree.add(organType);
        this.getTypeTree(organType, types, typeTree);
        for (SysOrganType type : types) {
            if (typeTree.contains(type.getOrganType())) continue;
            result.add(type);
        }
        return result;
    }

    public List<OrganizationTypeTreeVo> getOrgTypeTree() {
        List<OrganizationTypeTreeVo> types = this.sysOrganTypeMapper.getOrgTypeTree();
        return HussarTreeParser.getTreeList(types);
    }

    private void getTypeTree(String organType, List<SysOrganType> types, List<String> result) {
        for (SysOrganType type : types) {
            String parentType = type.getParentType();
            if (!organType.equals(parentType)) continue;
            result.add(type.getOrganType());
            this.getTypeTree(type.getOrganType(), types, result);
        }
    }

    @HussarDs(value="#connName")
    public boolean updateById(String connName, SysOrganType sysOrganType) {
        return this.updateById((BaseEntity)sysOrganType);
    }

    @HussarDs(value="#connName")
    public void saveOrUpdate(String connName, SysOrganType sysOrganType) {
        this.saveOrUpdate((BaseEntity)sysOrganType);
    }

    @HussarDs(value="#connName")
    public void removeById(String connName, SysOrganType sysOrganType) {
        this.removeById((BaseEntity)sysOrganType);
    }

    @HussarDs(value="#connName")
    public boolean remove(String connName, Wrapper<SysOrganType> wrapper) {
        return super.remove(wrapper);
    }

    @HussarDs(value="#connName")
    public boolean saveBatch(String connName, List<SysOrganType> entityList) {
        return super.saveBatch(entityList);
    }
}

