/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.TransferStaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.TransferStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.transferStaffManagerImpl")
public class TransferStaffManagerImpl
extends CommonStaffManager
implements TransferStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferStaffManagerImpl.class);
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    ISysOrgEventService sysOrgEventService;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;

    @Override
    public String transferStaff(TransferStaffDto transferStaffDto) {
        LOGGER.info("\u6267\u884c\u4eba\u5458\u8f6c\u79fb,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)transferStaffDto));
        String validateMsg = this.validateService.validate((Object)transferStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long oldId = transferStaffDto.getOldId();
        Long newId = transferStaffDto.getNewId();
        SysStru oldSysStru = (SysStru)this.sysStruMapper.selectById(oldId);
        SysStru newSysStru = (SysStru)this.sysStruMapper.selectById(newId);
        AssertUtil.isNotNull((Object)oldSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_TRANS_PRES.getMessage()));
        AssertUtil.isTrue((boolean)oldSysStru.getStruType().equals("9"), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_TYPE_MISMATCH.getMessage()));
        AssertUtil.isNotNull((Object)newSysStru, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_FIND_NEED_TRANS_ORG.getMessage()));
        this.validateTransferOrganization(oldSysStru, newSysStru);
        this.sysOrgEventService.beforeOrgChange(oldId, newId);
        String msg = this.doTransfer(oldSysStru, newSysStru);
        this.sysOrgEventService.afterOrgChange(oldId, newId);
        return msg;
    }

    private String doTransfer(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_TRANSFER_TO.getMessage()), (Object)oldSysStru.getId(), (Object)newSysStru.getId());
        String msg = "";
        String orgType = oldSysStru.getStruType();
        Long orgId = oldSysStru.getId();
        Long parentId = newSysStru.getId();
        Integer changeLevel = newSysStru.getStruLevel();
        List sysUsersList = new ArrayList();
        if ("9".equals(orgType)) {
            sysUsersList = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)orgId));
            AtomicReference<Integer> userOrder = new AtomicReference<Integer>(this.sysUsersService.getMaxOrder(parentId));
            if (ToolUtil.isEmpty((Object)userOrder.get())) {
                userOrder.set(1);
            } else {
                userOrder.set(userOrder.get() + 1);
            }
            for (SysUsers sysUsers : sysUsersList) {
                ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysUsers)).handle(() -> {
                    if (this.sysUsersAuditService.adjustEdit(sysUsers.getId())) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_MOVE.getMessage()));
                    }
                    sysUsers.setCorporationId(parentId);
                    sysUsers.setDepartmentId(parentId);
                    sysUsers.setUserOrder(userOrder.getAndSet((Integer)userOrder.get() + 1));
                });
            }
        }
        AtomicReference<Integer> orderTree = new AtomicReference<Integer>(1);
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty((Object)maxOrder)).handle(() -> orderTree.set(maxOrder + 1));
        Integer struOrder = orderTree.get();
        Integer level = changeLevel + 1;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(level);
            sysStruAudit.setParentId(parentId);
            this.sysStruAuditService.save((Object)sysStruAudit);
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS_WAIT_REVIEW.getMessage());
        } else {
            this.transferOrganizationManager.organizationChange(orgId, parentId, orgType, struOrder);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)orgId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)parentId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty(sysUsersList)) {
                for (SysUsers sysUsers : sysUsersList) {
                    this.sysUsersMapper.updateById(sysUsers);
                }
            }
            msg = TranslateUtil.getTranslateName((String)TipConstantsEnum.MOVE_SUCCESS.getMessage());
        }
        return msg;
    }

    private void validateTransferOrganization(SysStru oldSysStru, SysStru newSysStru) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_VALIDATE_TRANSFER.getMessage()));
        this.whetherComplianceWithOrganizationRule(oldSysStru, newSysStru);
        this.existsAuditData(oldSysStru.getId(), newSysStru.getId());
    }

    private void existsAuditData(Long oldId, Long newId) {
        if (!this.sysStruAuditService.checkCanOperate(oldId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_MOVE.getMessage()));
        }
        if (!this.sysStruAuditService.checkCanOperate(newId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TRANS_ORG_HAS_UNAPPROVED.getMessage()));
        }
    }

    private void whetherComplianceWithOrganizationRule(SysStru oldSysStru, SysStru newSysStru) {
        String oldOrganType = oldSysStru.getStruType();
        String newOrganType = newSysStru.getStruType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getSysOrganType, (Object)newOrganType);
        wrapper.eq(SysStruRule::getOrganType, (Object)oldOrganType);
        long count = this.sysStruRuleMapper.selectCount((Wrapper)wrapper);
        if (count == 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ORGAN_MOVE_FAIL_THIS_ORGANIZATION_NOT_ALLOW.getMessage()));
        }
    }
}

