/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.enums.ExcelOrganLimitTypeEnum;
import com.jxdinfo.hussar.authorization.organ.enums.OrganExcelEnum;
import com.jxdinfo.hussar.authorization.organ.manager.ExportOrganExcelManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcelExportDesc;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.handler.CustomSheetWriteHandler;
import com.jxdinfo.hussar.excel.handler.DataValidationSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.CustomVerticalCellStyleStrategy;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.exportOrganExcelManagerImpl")
public class ExportOrganExcelManagerImpl
extends CommonQueryOrganizationManager
implements ExportOrganExcelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportOrganExcelManagerImpl.class);
    @Resource
    protected IProtectionStatusConfigBoService protectionStatusConfigBoService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelService;
    @Resource
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ISysStruService sysStruService;
    private static final int TEMPLATE_ROW_NUM = 5;

    @Override
    public void exportOrganExcel(String ids, Long taskId, boolean exportKey) throws Exception {
        Long inOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new Exception(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DATA_TO_EXPORT.getMessage()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List<String> idList = Arrays.asList(ids.split(","));
        HashSet<Long> allStruIds = new HashSet<Long>();
        List<Long> struIds = idList.stream().map(s -> Long.parseLong(s.trim())).filter(e -> !HussarUtils.equals((Object)inOrganNodeId, (Object)e) && !HussarUtils.equals((Object)outOrganNodeId, (Object)e)).collect(Collectors.toList());
        List<Long> parentIds = this.getParentByIds(struIds);
        List<Long> subStruIds = this.getSubOrganByIds(struIds);
        allStruIds.addAll(parentIds);
        allStruIds.addAll(subStruIds);
        List<OrganExcel> organExcelList = this.sysStruMapper.getOrganExcelByStruIds(new ArrayList<Long>(allStruIds), null);
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(OrganExcel.class, organExcelList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()), 0);
            List<String> alignList = Arrays.asList(new String[8]);
            alignList.set(3, "left");
            alignList.set(6, "left");
            alignList.set(7, "left");
            CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
            classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
            Map<Integer, List<String>> selectParamMap = this.getOrganExcelOptions();
            classSheetMsg1.addHandler((WriteHandler)new DataValidationSheetWriteHandler(selectParamMap));
            classSheetMsg1.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getOrganExcelStyle()));
            if (!exportKey) {
                classSheetMsg1.setExcludeColumnIndexes(Collections.singletonList(12));
            }
            OrganExcelExportDesc organExcelExportDesc = new OrganExcelExportDesc();
            organExcelExportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
            organExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
            ArrayList<OrganExcelExportDesc> organExcelExportDescList = new ArrayList<OrganExcelExportDesc>();
            organExcelExportDescList.add(organExcelExportDesc);
            ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(OrganExcelExportDesc.class, organExcelExportDescList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_DESCRIPTION.getMessage()), 1);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()) + exportTime + ".xlsx", taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById(excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                LocaleContextHolder.resetLocaleContext();
            }
        });
    }

    @Override
    public void exportOrganExcelWithSecurity(String ids, Long taskId, boolean exportKey, String securityLevel) throws Exception {
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new Exception(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DATA_TO_EXPORT.getMessage()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List<String> idList = Arrays.asList(ids.split(","));
        HashSet<Long> allStruIds = new HashSet<Long>();
        List<Long> struIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<Long> parentIds = this.getParentByIds(struIds);
        allStruIds.addAll(parentIds);
        List<String> struFids = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)Character.valueOf('0'))).stream().map(SysStru::getStruFid).filter(Objects::nonNull).map(originalValue -> originalValue + "%").collect(Collectors.toList());
        List<OrganExcel> organExcelList = this.sysStruMapper.getOrganExcelByStruIdsOrStruFidLike(new ArrayList<Long>(allStruIds), null, struFids);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        Locale locale = LocaleContextHolder.getLocale();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(OrganExcel.class, organExcelList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()), 0);
            List<String> alignList = Arrays.asList(new String[8]);
            alignList.set(3, "left");
            alignList.set(6, "left");
            alignList.set(7, "left");
            CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
            classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
            Map<Integer, List<String>> selectParamMap = this.getOrganExcelOptions();
            classSheetMsg1.addHandler((WriteHandler)new DataValidationSheetWriteHandler(selectParamMap));
            classSheetMsg1.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getOrganExcelStyle()));
            if (!exportKey) {
                classSheetMsg1.setExcludeColumnIndexes(Collections.singletonList(12));
            }
            OrganExcelExportDesc organExcelExportDesc = new OrganExcelExportDesc();
            organExcelExportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
            organExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
            ArrayList<OrganExcelExportDesc> organExcelExportDescList = new ArrayList<OrganExcelExportDesc>();
            organExcelExportDescList.add(organExcelExportDesc);
            ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(OrganExcelExportDesc.class, organExcelExportDescList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_DESCRIPTION.getMessage()), 1);
            try {
                String excelFileName = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()) + exportTime + ".xlsx";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
                    String securityLabel = this.getFileSecurityLevelLabel(securityLevel);
                    excelFileName = "\uff08" + securityLabel + "\uff09" + "-" + excelFileName;
                }
                ExcelProduct excelProduct = new ConcreteExcelBuilder(excelFileName, taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById(excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void exportOrganExcelWithSecurityForBigDate(List<String> idList, Long taskId, Boolean exportKey, String securityLevel) throws Exception {
        if (HussarUtils.isEmpty(idList)) {
            throw new Exception(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DATA_TO_EXPORT.getMessage()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List struIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        Locale locale = LocaleContextHolder.getLocale();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            LocaleContextHolder.setLocale((Locale)locale);
            ExportOrganExcelManager organExcelManager = (ExportOrganExcelManager)SpringContextHolder.getBean(ExportOrganExcelManager.class);
            List<OrganExcel> organExcelList = organExcelManager.getOrganExcelList(struIds);
            ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(OrganExcel.class, organExcelList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()), 0);
            List<String> alignList = Arrays.asList(new String[8]);
            alignList.set(3, "left");
            alignList.set(6, "left");
            alignList.set(7, "left");
            CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
            classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
            Map<Integer, List<String>> selectParamMap = this.getOrganExcelOptions();
            classSheetMsg1.addHandler((WriteHandler)new DataValidationSheetWriteHandler(selectParamMap));
            classSheetMsg1.addHandler((WriteHandler)new CustomSheetWriteHandler(this.getOrganExcelStyle()));
            if (!exportKey.booleanValue()) {
                classSheetMsg1.setExcludeColumnIndexes(Collections.singletonList(12));
            }
            OrganExcelExportDesc organExcelExportDesc = new OrganExcelExportDesc();
            organExcelExportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
            organExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
            ArrayList<OrganExcelExportDesc> organExcelExportDescList = new ArrayList<OrganExcelExportDesc>();
            organExcelExportDescList.add(organExcelExportDesc);
            ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(OrganExcelExportDesc.class, organExcelExportDescList, TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_DESCRIPTION.getMessage()), 1);
            try {
                String excelFileName = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXPORT_SHEET_NAME.getMessage()) + exportTime + ".xlsx";
                if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue() && HussarUtils.isNotEmpty((Object)securityLevel)) {
                    String securityLabel = this.getFileSecurityLevelLabel(securityLevel);
                    excelFileName = "\uff08" + securityLabel + "\uff09" + "-" + excelFileName;
                }
                ExcelProduct excelProduct = new ConcreteExcelBuilder(excelFileName, taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById(excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                LocaleContextHolder.resetLocaleContext();
            }
        });
    }

    @Override
    public List<OrganExcel> getOrganExcelList(List<Long> struIds) {
        HashSet<Long> allStruIds = new HashSet<Long>();
        List<Long> parentIds = this.getParentByIds(struIds);
        List<Long> subStruIds = this.getSubOrganByIds(struIds);
        allStruIds.addAll(parentIds);
        allStruIds.addAll(subStruIds);
        List splitList = LambdaQueryUtil.getSplitList(new ArrayList(allStruIds));
        List<OrganExcel> organExcelList = this.sysStruMapper.getOrganExcelByStruIdsForBigDate(splitList, null);
        return organExcelList;
    }

    private Map<Integer, Short> getOrganExcelStyle() {
        HashMap<Integer, Short> styleMap = new HashMap<Integer, Short>();
        styleMap.put(OrganExcelEnum.ORGAN_CODE.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.ORGAN_NAME.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.SHORT_NAME.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.ORGAN_ALIAS.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.OFFICE_ALIAS.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.OFFICE_ADDRESS.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.USER_ACCOUNT.getIndex(), (short)49);
        styleMap.put(OrganExcelEnum.STRU_ID.getIndex(), (short)49);
        return styleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadOrganExcelImpTpl(HttpServletResponse response, String fileKey) {
        Long inOrganNodeId = this.hussarSystemIdProperties.getInnerOrganNodeId();
        Long outOrganNodeId = this.hussarSystemIdProperties.getOutOrganNodeId();
        InputStream inputStream = null;
        try (ServletOutputStream out = response.getOutputStream();){
            String fileName = "";
            response.setContentType("multipart/form-data");
            fileName = this.protectionStatusConfigBoService.isFenBaoEnable() != false ? URLEncoder.encode("\uff08" + TranslateUtil.getTranslateName((String)TipConstantsEnum.TRANSLATE_DICT_CONSTANT_PUBLIC.getMessage()) + "\uff09" + "-" + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_EXCEL_IMPORT.getMessage()) + ".xlsx", "UTF-8") : URLEncoder.encode(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_EXCEL_IMPORT.getMessage()) + ".xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            fileKey = HussarUtils.isEmpty((Object)fileKey) ? "organImportTpl" : fileKey;
            Locale locale = LocaleContextHolder.getLocale();
            String lang = locale.toLanguageTag();
            String langModify = lang.replace("-", "").toUpperCase();
            if (!LangEnum.ZH_CN.getLangValue().equals(lang)) {
                if (HussarUtils.isEmpty((Object)fileKey)) {
                    fileKey = "organImportTpl" + langModify;
                    ExcelConstants.TemplateMap.put(fileKey, "static/" + fileKey + ".xlsx");
                } else {
                    fileKey = fileKey + langModify;
                    ExcelConstants.TemplateMap.put(fileKey, "static/" + fileKey + ".xlsx");
                }
            }
            ClassPathResource resource = new ClassPathResource((String)ExcelConstants.TemplateMap.get(fileKey));
            inputStream = resource.getStream();
            Workbook workbook = HussarBaseExcelWriteUtils.judegExcelEdition((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_EXCEL_IMPORT.getMessage()), (InputStream)inputStream);
            Sheet sheet2 = workbook.getSheetAt(2);
            List listOrganType = this.sysOrganTypeMapper.selectList(null);
            ArrayList<String> result = new ArrayList<String>();
            Map<String, SysOrganType> organTypeMap = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
            List rules = this.sysStruRuleMapper.selectList(null);
            Map<String, List<SysStruRule>> map = rules.stream().collect(Collectors.groupingBy(SysStruRule::getSysOrganType));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysOrganType::getParentType, (Object)"0");
            List firstLevelTypes = this.sysOrganTypeMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)firstLevelTypes)) {
                for (SysOrganType firstLevelType : firstLevelTypes) {
                    String type = firstLevelType.getOrganType();
                    result.add(type);
                    ExportOrganExcelManagerImpl.getFinalOrganType(map, type, organTypeMap, result);
                }
            }
            for (int i = 0; i < result.size(); ++i) {
                Row row = sheet2.getRow(i + 1);
                if (HussarUtils.isEmpty((Object)row)) {
                    row = sheet2.createRow(i + 1);
                }
                String organType = (String)result.get(i);
                row.createCell(0).setCellValue(organTypeMap.get(organType).getTypeName());
            }
            ArrayList<String> organPropertyList = new ArrayList<String>();
            organPropertyList.add(this.sysStruService.getOrganFname(inOrganNodeId));
            organPropertyList.add(this.sysStruService.getOrganFname(outOrganNodeId));
            for (int i = 0; i < organPropertyList.size(); ++i) {
                Row row = sheet2.getRow(i + 1) == null ? sheet2.createRow(i + 1) : sheet2.getRow(i + 1);
                Cell cell = row.getCell(2) == null ? row.createCell(1) : row.getCell(1);
                cell.setCellValue((String)organPropertyList.get(i));
            }
            Sheet sheet1 = workbook.getSheetAt(1);
            for (int i = 1; i < 5; ++i) {
                Row row = sheet1.getRow(i) == null ? sheet1.createRow(i) : sheet1.getRow(i);
                Cell cell = row.getCell(9) == null ? row.createCell(9) : row.getCell(9);
                cell.setCellValue((String)organPropertyList.get(0));
            }
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("inputStream close IOException:" + e.getMessage());
                }
            }
        }
    }

    private static void getFinalOrganType(Map<String, List<SysStruRule>> map, String type, Map<String, SysOrganType> organTypeMap, List<String> result) {
        List<SysStruRule> ruleList = map.get(type);
        if (HussarUtils.isNotEmpty(ruleList)) {
            for (SysStruRule rule : ruleList) {
                String organType = rule.getOrganType();
                SysOrganType sysOrganType = organTypeMap.get(organType);
                if (!HussarUtils.isNotEmpty((Object)sysOrganType) || result.contains(organType)) continue;
                result.add(organType);
                ExportOrganExcelManagerImpl.getFinalOrganType(map, organType, organTypeMap, result);
            }
        }
    }

    @Override
    public Map<Integer, List<String>> getOrganExcelOptions() {
        ArrayList<String> organPropertyList = new ArrayList<String>();
        organPropertyList.add(this.sysStruService.getOrganFname(this.hussarSystemIdProperties.getInnerOrganNodeId()));
        organPropertyList.add(this.sysStruService.getOrganFname(this.hussarSystemIdProperties.getOutOrganNodeId()));
        HashMap<Integer, List<String>> selectParamMap = new HashMap<Integer, List<String>>();
        List listOrganType = this.organTypeService.list();
        selectParamMap.put(OrganExcelEnum.ORGAN_TYPE_NAME.getIndex(), listOrganType.stream().map(SysOrganType::getTypeName).collect(Collectors.toList()));
        selectParamMap.put(OrganExcelEnum.ORGAN_PROPERTY.getIndex(), organPropertyList);
        selectParamMap.put(OrganExcelEnum.VALID_TIME_LIMIT_TYPE.getIndex(), Arrays.stream(ExcelOrganLimitTypeEnum.values()).map(ExcelOrganLimitTypeEnum::getLabel).collect(Collectors.toList()));
        return selectParamMap;
    }

    @Override
    protected String getFileSecurityLevelLabel(String securityLevel) {
        String securityLabel = this.sysDicRefService.getDictLabelTranslate("security_level", securityLevel);
        if (HussarUtils.isNotEmpty((Object)securityLabel)) {
            return securityLabel;
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.TRANSLATE_DICT_CONSTANT_PUBLIC.getMessage());
    }

    static {
        ExcelConstants.TemplateMap.put("organImportTpl", "static/organImportTpl.xlsx");
        ExcelConstants.TemplateMap.put("organImportTplWithKey", "static/organImportTplWithKey.xlsx");
    }
}

