/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysRoleDataRightServiceImpl
extends HussarServiceImpl<SysRoleDataRightMapper, SysRoleDataRight>
implements ISysRoleDataRightService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysRoleDataRightServiceImpl.class);
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysRoleStruRightService sysRoleStruRightService;

    public void insertOrUpdateRoleDataRightList(List<SysRoleDataRight> sysRoleDataRights) {
        if (CollectionUtils.isEmpty(sysRoleDataRights)) {
            LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_DATA_ADD_RIGHT.getMessage()), (Object)sysRoleDataRights.size());
            LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_DATA_EDIT_RIGHT.getMessage()), (Object)sysRoleDataRights.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
        ArrayList<SysRoleDataRight> insertData = new ArrayList<SysRoleDataRight>();
        ArrayList<SysRoleDataRight> updateData = new ArrayList<SysRoleDataRight>();
        for (SysRoleDataRight item : sysRoleDataRights) {
            if (allIds.contains(item.getDataRightsId())) {
                updateData.add(item);
                continue;
            }
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_DATA_ADD_RIGHT.getMessage()), (Object)insertData.size());
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_DATA_EDIT_RIGHT.getMessage()), (Object)updateData.size());
    }

    public List<SysRoleDataRight> selectRoleDataRightsByFuncIds(List<Long> funcIds) {
        if (HussarUtils.isEmpty(funcIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long funcId : funcIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoleDataRight::getFunctionId, (Object)funcId);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public Boolean deleteDataRightByAppId(Long appId) {
        List sysFunctions = this.sysFunctionsService.listFunctionsByAppId(appId);
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        if (HussarUtils.isEmpty(functionIds)) {
            return Boolean.FALSE;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleDataRight::getFunctionId, functionIds);
        List roleDataRights = this.list((Wrapper)queryWrapper);
        List customDataRightIds = roleDataRights.stream().filter(item -> HussarUtils.equals((Object)"5", (Object)item.getDataScope())).map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(customDataRightIds)) {
            this.sysRoleStruRightService.deleteByRoleDataRightIds(customDataRightIds);
        }
        return this.remove((Wrapper)new LambdaQueryWrapper().in(SysRoleDataRight::getFunctionId, functionIds));
    }

    public Boolean deleteDtaRightByRoleId(Long roleId) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleDataRight::getRoleId, (Object)roleId));
        this.sysRoleStruRightService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleStruRights::getRoleId, (Object)roleId));
        return Boolean.TRUE;
    }
}

