/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ILocalStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.LocalStaffBoServiceImpl")
public class LocalStaffBoServiceImpl
implements ILocalStaffBoService {
    @Autowired
    @Lazy
    private QueryStaffManager queryStaffManager;
    @Autowired
    private ISysUsersService usersService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private ISysDicRefService dicRefService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;

    public StaffBo findStaffByStaffId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        StaffInfoVo staffInfoVo = this.queryStaffManager.loadStaff(id);
        StaffBo bo = new StaffBo();
        bo.setId(id);
        bo.setParentId(staffInfoVo.getParentId());
        bo.setParentOrganName(staffInfoVo.getParentName());
        bo.setParentOrganType(staffInfoVo.getParentStruType());
        bo.setParentOrganTypeName(staffInfoVo.getParentStruTypeName());
        bo.setStaffCode(staffInfoVo.getStaffCode());
        bo.setStaffName(staffInfoVo.getStaffName());
        bo.setStaffPosition(staffInfoVo.getStaffPosition());
        bo.setStaffPositionName(staffInfoVo.getStaffPositionName());
        bo.setSex(staffInfoVo.getSex());
        bo.setSexName(staffInfoVo.getSexName());
        bo.setBirthday(staffInfoVo.getBirthday());
        bo.setIdcard(staffInfoVo.getIdcard());
        bo.setAddress(staffInfoVo.getAddress());
        bo.setWorkId(staffInfoVo.getWorkId());
        bo.setWorkDate(staffInfoVo.getWorkDate());
        bo.setGraduateDate(staffInfoVo.getGraduateDate());
        bo.setGraduateSchool(staffInfoVo.getGraduateSchool());
        bo.setOrganList(staffInfoVo.getOrganList());
        bo.setExpansionMap(HussarUtils.isNotEmpty((Object)staffInfoVo.getExpansionMap()) ? staffInfoVo.getExpansionMap() : new HashMap());
        return bo;
    }

    public StaffBo findStaffByUserId(Long id) {
        SysUsers user = this.usersService.getUser(id);
        AssertUtil.isNotNull((Object)user, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        return this.findStaffByStaffId(user.getEmployeeId());
    }

    public List<StaffBo> findStaffsByStaffIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        ArrayList<StaffBo> list = new ArrayList<StaffBo>();
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStruStaff::getStaffId, ids);
        List struStaffs = this.sysStruStaffService.list((Wrapper)relationWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        AssertUtil.isNotEmpty((Collection)struStaffs, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
        Map map = struStaffs.stream().collect(Collectors.groupingBy(SysStruStaff::getStaffId, Collectors.mapping(SysStruStaff::getStruId, Collectors.toList())));
        List<Long> struIds = struStaffs.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
        List<OrganVo> organVos = this.sysStruMapper.getOrgansByStruIds(struIds);
        Map organMap = organVos.stream().collect(Collectors.toMap(OrganVo::getId, Function.identity()));
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getId, ids);
        List staffs = this.sysStaffMapper.selectList((Wrapper)wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        AssertUtil.isNotEmpty((Collection)staffs, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PERSONNEL_INFO.getMessage()));
        List positions = this.dicRefService.getDicListByType("staff_position");
        Map<String, String> postionMap = positions.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List sexList = this.dicRefService.getDicListByType("sex");
        Map<String, String> sexMap = sexList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        for (SysStaff staff : staffs) {
            StaffBo bo = new StaffBo();
            bo.setId(staff.getId());
            bo.setStaffCode(staff.getStaffCode());
            bo.setStaffName(staff.getName());
            bo.setStaffPosition(staff.getStaffPosition());
            bo.setStaffPositionName(postionMap.get(staff.getStaffPosition()));
            bo.setAddress(staff.getAddress());
            bo.setSex(staff.getSex());
            bo.setSexName(sexMap.get(staff.getSex()));
            bo.setBirthday(staff.getBirthday());
            bo.setIdcard(staff.getIdcard());
            bo.setWorkId(staff.getWorkId());
            bo.setWorkDate(staff.getWorkDate());
            bo.setGraduateDate(staff.getGraduateDate());
            bo.setGraduateSchool(staff.getGraduateSchool());
            bo.setExpansionMap(HussarUtils.isNotEmpty((Object)staff.getExpansionMap()) ? staff.getExpansionMap() : new HashMap());
            List struIdList = map.get(staff.getId());
            ArrayList<OrganVo> voList = new ArrayList<OrganVo>();
            for (Long struId : struIdList) {
                OrganVo organVo = (OrganVo)organMap.get(String.valueOf(struId));
                if (!HussarUtils.isNotEmpty((Object)organVo)) continue;
                voList.add(organVo);
            }
            bo.setOrganList(voList);
            list.add(bo);
        }
        return list;
    }

    public List<StaffBo> findStaffsByUserIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, ids);
        List users = this.usersService.list((Wrapper)relationWrapper.ne(SysUsers::getAccountStatus, (Object)"2"));
        List<Long> collect = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
        return this.findStaffsByStaffIds(collect);
    }

    public StaffBo findStaffByUserAccount(String account) {
        AssertUtil.isNotEmpty((String)account, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getUserAccount, (Object)account);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            Long userId = sysUsers.getId();
            return this.findStaffByUserId(userId);
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PERSONNEL_INFO.getMessage()));
    }

    public List<StaffBo> findStaffsByUserAccounts(List<String> accounts) {
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getUserAccount, accounts);
        List users = this.usersService.list((Wrapper)relationWrapper.ne(SysUsers::getAccountStatus, (Object)"2"));
        List<Long> collect = users.stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
        return this.findStaffsByStaffIds(collect);
    }

    public StaffBo findStaffByStaffCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStaffCode, (Object)code));
        if (HussarUtils.isEmpty((Object)sysStaff)) {
            return null;
        }
        AssertUtil.isNotNull((Object)sysStaff, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_DATA_FOUND.getMessage()));
        return this.findStaffByStaffId(sysStaff.getId());
    }

    public List<StaffBo> findStaffsByStaffCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        LambdaQueryWrapper relationWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysStaff::getStaffCode, codes);
        List sysStaffs = this.sysStaffMapper.selectList((Wrapper)relationWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List<Long> staffIds = sysStaffs.stream().map(SysStaff::getId).collect(Collectors.toList());
        if (HussarUtils.isEmpty(staffIds)) {
            return Collections.emptyList();
        }
        return this.findStaffsByStaffIds(staffIds);
    }

    public Page<StaffVo> list(PageInfo pageInfo, Long organId, String staffName, String staffCode) {
        return this.queryStaffManager.list(pageInfo, organId, staffName, staffCode);
    }
}

