/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsidePostRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsideStruRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsideUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.OutsideRoleGroupDto;
import com.jxdinfo.hussar.authorization.permit.manager.OutsideRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.outsideRoleManagerImpl")
public class OutsideRoleManagerImpl
implements OutsideRoleManager {
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysPostRoleService sysPostRoleService;

    @Override
    public R<OutsideRoleGroupDto> addRoleGroup(OutsideRoleGroupDto roleGroup) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)roleGroup);
        Long groupId = roleGroup.getGroupId();
        SysRoleGroup sysRoleGroup = new SysRoleGroup();
        if (HussarUtils.isNotEmpty((Object)groupId)) {
            SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId);
            if (HussarUtils.isNotEmpty((Object)group)) {
                OrganUtil.addErrorMsg((List)errors, (Object)roleGroup, (String)"groupId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ID_DUPLICATE.getMessage())});
            }
        } else {
            groupId = IdWorker.getId((Object)sysRoleGroup);
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            String groupName = StringUtils.trimToEmpty((String)roleGroup.getGroupName());
            String groupAlias = StringUtils.trimToEmpty((String)roleGroup.getGroupAlias());
            sysRoleGroup.setId(groupId);
            sysRoleGroup.setGroupName(groupName);
            sysRoleGroup.setGroupAlias(groupAlias);
            sysRoleGroup.setParentId(Long.valueOf(1L));
            sysRoleGroup.setIsSys("0");
            int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
            sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
            this.sysRoleGroupMapper.insert(sysRoleGroup);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    @Override
    public R<OutsideRoleGroupDto> editRoleGroup(OutsideRoleGroupDto roleGroup) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)roleGroup);
        Long groupId = roleGroup.getGroupId();
        if (HussarUtils.isEmpty((Object)groupId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_ID_NOT_NULL.getMessage()));
        }
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId);
        if (HussarUtils.isEmpty((Object)sysRoleGroup)) {
            OrganUtil.addErrorMsg((List)errors, (Object)roleGroup, (String)"groupId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_GROUP_RULE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            String groupName = StringUtils.trimToEmpty((String)roleGroup.getGroupName());
            String groupAlias = StringUtils.trimToEmpty((String)roleGroup.getGroupAlias());
            sysRoleGroup.setGroupName(groupName);
            sysRoleGroup.setGroupAlias(groupAlias);
            this.sysRoleGroupMapper.updateById(sysRoleGroup);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    @Override
    public R<Long> deleteRoleGroup(Long roleGroupId) {
        R result = new R();
        ArrayList errors = new ArrayList();
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(roleGroupId);
        if (sysRoleGroup == null) {
            OrganUtil.addErrorMsg(errors, (Object)roleGroupId, (String)"roleGroupId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_GROUP_RULE_EMPTY.getMessage())});
        } else {
            Long count = this.sysRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)roleGroupId));
            if (count > 0L) {
                OrganUtil.addErrorMsg(errors, (Object)roleGroupId, (String)"roleGroupId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_GROUP_NOT_EMPTY.getMessage())});
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            this.sysRoleGroupMapper.deleteById(roleGroupId);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
        }
        return result;
    }

    @Override
    public Boolean saveUserRole(AddOutsideUserRoleDto userRoleDto) {
        List ids = userRoleDto.getIds();
        String type = userRoleDto.getType();
        List userRoleList = userRoleDto.getUserRoleList();
        if ("user".equals(type)) {
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, (Collection)ids));
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_OR_ROLE_TYPE.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)userRoleList)) {
            for (SysUserRole sysUserRole : userRoleList) {
                sysUserRole.setAdminOption("1");
            }
            this.sysUserRoleService.saveBatch((Collection)userRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveStruRole(AddOutsideStruRoleDto struRoleDto) {
        List ids = struRoleDto.getIds();
        String type = struRoleDto.getType();
        List struRoleList = struRoleDto.getStruRoleList();
        if ("organ".equals(type)) {
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getGrantedRole, (Collection)ids));
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_NOT_SUPPORTED.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)struRoleList)) {
            this.sysStruRoleService.saveBatch((Collection)struRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean savePostRole(AddOutsidePostRoleDto postRoleDto) {
        List ids = postRoleDto.getIds();
        String type = postRoleDto.getType();
        List postRoleList = postRoleDto.getPostRoleList();
        if ("post".equals(type)) {
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getRoleId, (Collection)ids));
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_TYPE_NOT_SUPPORTED.getMessage()));
        }
        if (HussarUtils.isNotEmpty((Object)postRoleList)) {
            this.sysPostRoleService.saveBatch((Collection)postRoleList);
        }
        return Boolean.TRUE;
    }
}

